% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateTrialData.R
\name{simulateTrialData}
\alias{simulateTrialData}
\title{Generate simulation endpoint data for an arm in a trial.}
\usage{
simulateTrialData(
  ...,
  cor_matrix,
  trial_size = 100,
  arm_label = NULL,
  var_prefix = "easySimData"
)
}
\arguments{
\item{...}{calls describing the marginal distributions of endpoints. They
can be data frames, e.g., \code{df}, or valid R expressions evaluated to be data
frames, e.g., \code{data.frame(x = runif(10), y = 1)}, \code{df \%>\% filter(x < 1)},
\code{myFunctionReturnDataFrame()}, or simply any quantile functions (see the
\code{dist} argument of \code{simdata::simdesign_norta}).}

\item{cor_matrix}{a target correlation matrix. See the \code{cor_target_final}
argument of \code{simdata::simdesign_norta}.}

\item{trial_size}{size of an arm.}

\item{arm_label}{a character to name the arm. When specified, a column \code{arm}
will be added to the end of the simulated data frame. NULL by default.}

\item{var_prefix}{a character as the prefix of endpoints specified by common
distributions.}
}
\value{
A data frame of endpoints.
}
\description{
Parameters of marginal distribution of endpoints and their target correlation
are specified. This function returns endpoint data of one arm. To generate
data of multiple arms, one need to call this function for each of the arms.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)
data(df)
head(df)

cmat <- matrix(.5, 10, 10)
diag(cmat) <- 1.

## the first argument should always be x if a user-defined quantile function
## is supplied. This is required by the `simdata` package.
user_qfun <- function(x, shape1 = .6, shape2 = 1.2){
  qbeta(x, shape1 = shape1, shape2 = shape2)
}

data <- simulateTrialData(
  df[, c('Gender', 'Age')] \%>\% dplyr::filter(Age < 50), # an expression with
                                                        # its value a data frame
  df \%>\% dplyr::select(-c(Gender, Age, Race)), # same as above
  norm(mean = 0.2,sd = 1.2), # distribution name. Note that it is not a valid
                             # R function but a symbol.
  binom(prob =.4, size=1  ), # spaces are ignore, order does not matter
  norm(mean =-0.4, sd=0.9),  # same distribution with different parameters
  user_qfun,                 # user-defined quantile

  cor_matrix = cmat,
  trial_size = 1000,
  arm_label = 'placebo'
)

## for diagnosis
plot(data)
cor(data \%>\% dplyr::select(-matches('arm')))

## Note that user_qfun is simply the quantile function of a beta distribution,
## so a preferred way to use easySimData is as follow
data <- simulateTrialData(
  df[, c('Gender', 'Age')] \%>\% dplyr::filter(Age < 50), # an expression with
                                                        # its value a data frame
  df \%>\% dplyr::select(-c(Gender, Age, Race)), # same as above
  norm(mean = 0.2,sd = 1.2), # distribution name. Note that it is not a valid
                             # R function but a symbol.
  binom(prob =.4, size=1  ), # spaces are ignored, order does not matter
  norm(mean =-0.4, sd=0.9),  # same distribution with different parameters
  beta(shape1 = .5, shape2 = 1.2), # distribution name

  cor_matrix = cmat,
  trial_size = 1000,
  arm_label = 'placebo'
)

\dontshow{\}) # examplesIf}
}
