% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getEasingDetails}
\alias{getEasingDetails}
\title{Get credit easing details.}
\usage{
getEasingDetails(startDate = "012007", endDate = "122100")
}
\arguments{
\item{startDate}{query start date string in MMYYYY format, default 012007}

\item{endDate}{query end date string in MMYYYY format, default 122100}
}
\value{
A list of class \code{easing}
}
\description{
Downloads FRB credit easing policy details data.
}
\details{
Downloads the Cleveland FRB data product for credit easing policy detail weekly time series, including columns for
\itemize{
\item traditional security
\item securities lent to dealers
\item repurchase agreements
\item other fed assets
\item currency swaps
\item term auction credit
\item primary dealer
\item primary credit
\item secondary credit
\item seasonal credit
\item maiden lane 1
\item maiden lane 2
\item maiden lane 3
\item asset-backed commercial paper
\item net portfolio holdings commercial paper
\item other credit
\item credit to AIG
\item mortgage-backed securities
\item federal agency debt securities
\item term asset-backed securities
\item long-term treasury purchases
}
}
\examples{
\dontrun{
ed <- getEasingDetails()
head(ed$df)
}
}
\seealso{
getEasingData getEasingSummary getEasingLending getEasingCreditDepository getEasingCreditExtensions getEasingProvidingLiquidity getEasingMaidenLane getEasingTraditionalHoldings  getEasingAgencyDebt getEasingLongTermPurchases
}

