% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf.R
\name{read_datasets}
\alias{read_datasets}
\alias{read.data.sets}
\title{Read several data sets}
\usage{
read_datasets(file, col_names, text)

read.data.sets(file, col.names)
}
\arguments{
\item{file}{Filename that contains the data.  Each row of the table appears
as one line of the file.  If it does not contain an \emph{absolute} path,
the file name is \emph{relative} to the current working directory,
\code{\link[base]{getwd}()}.  Tilde-expansion is performed where supported.}

\item{col_names, col.names}{Vector of optional names for the variables.  The
default is to use \samp{"V"} followed by the column number.}

\item{text}{(`character()`) \cr If \code{file} is not supplied and this is,
then data are read from the value of \code{text} via a text connection.
Notice that a literal string can be used to include (small) data sets
within R code.}
}
\value{
(`matrix()`) containing a representation of the
 data in the file. An extra column \code{set} is added to indicate to
 which set each row belongs.
}
\description{
Reads a text file in table format and creates a matrix from it. The file
may contain several sets, separated by empty lines. Lines starting by
\code{'#'} are considered comments and treated as empty lines. The function
adds an additional column \code{set} to indicate to which set each row
belongs.
}
\note{
There are several examples of data sets in
  \code{file.path(system.file(package="eaf"),"extdata")}.

\code{read.data.sets} is a deprecated alias. It will be removed in the next
  major release.
}
\section{Warning}{

 A known limitation is that the input file must use newline characters
 native to the host system, otherwise they will be, possibly silently,
 misinterpreted. In GNU/Linux the program \code{dos2unix} may be used
 to fix newline characters.
}

\examples{
A1 <- read_datasets(file.path(system.file(package="eaf"),"extdata","ALG_1_dat"))
str(A1)
A2 <- read_datasets(file.path(system.file(package="eaf"),"extdata","ALG_2_dat"))
str(A2)

read_datasets(text="1 2\\n3 4\\n\\n5 6\\n7 8\\n", col_names=c("obj1", "obj2"))

}
\seealso{
\code{\link[utils]{read.table}}, \code{\link{eafplot}}, \code{\link{eafdiffplot}}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
\keyword{file}
