% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{score.cindex}
\alias{score.cindex}
\title{Scoring function for evaluating survival prediction through concordance index (c-index)}
\usage{
score.cindex(pred, time, event, real)
}
\arguments{
\item{pred}{Numeric risk score for each event}

\item{time}{A vector of event or censoring times}

\item{event}{A binary valued vector that indicates either death (1) or right-censoring (0)}

\item{real}{A previously constructed Surv-object instead of providing time and event}
}
\value{
Corcordance index (c-index) of the prediction
}
\description{
C-index (Concordance index) of the predicted vs. true answer, i.e. proportion of pairs that go in correct direction over all pairwise comparisons
}
\examples{
# A random prediction ought to be near 0.5
# c-index is not sensitive to time scale, as it tests pairwise prediction accuracy
set.seed(1); prediction <- sample(1:20)
time <- seq(from=1000, to=50, by=-50)
event <- c(0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1)
library(survival)
score.cindex(pred = prediction, real = Surv(time=time, event=event))
}
