% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_expression.R
\name{add_expression}
\alias{add_expression}
\alias{is_wrapper_with_expression}
\alias{get_expression}
\title{Add count and normalised expression values to a dataset}
\usage{
add_expression(dataset, counts, expression, feature_info = NULL,
  expression_projected = NULL, ...)

is_wrapper_with_expression(dataset)

get_expression(dataset, expression_source = "expression")
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{counts}{The counts values of genes (columns) within cells (rows). This can be both a dense and sparse matrix.}

\item{expression}{The normalised expression values of genes (columns) within cells (rows). This can be both a dense and sparse matrix.}

\item{feature_info}{Optional meta-information of the features, a dataframe with at least \emph{feature_id} as column}

\item{expression_projected}{Projected expression using RNA velocity of genes (columns) within cells (rows).  This can be both a dense and sparse matrix.}

\item{...}{extra information to be stored in the dataset}

\item{expression_source}{The source of expression, can be "counts", "expression", an expression matrix, or another dataset which contains expression}
}
\description{
Add count and normalised expression values to a dataset
}
\examples{
cell_ids <- c("A", "B", "C")
counts <- matrix(sample(0:10, 3*10, replace = TRUE), nrow = 3)
rownames(counts) <- cell_ids
colnames(counts) <- letters[1:10]
expression <- log2(counts + 1)

dataset <- wrap_data(id = "my_awesome_dataset", cell_ids = cell_ids)
dataset <- add_expression(dataset, counts = counts, expression = expression)

str(dataset$expression)
str(dataset$counts)

}
\keyword{adapt_trajectory}
