% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_simulation_expression}
\alias{plot_simulation_expression}
\title{Visualise the expression of the simulations over simulation time}
\usage{
plot_simulation_expression(
  model,
  simulation_i = 1:4,
  what = c("mol_premrna", "mol_mrna", "mol_protein"),
  facet = c("simulation", "module_group", "module_id", "none"),
  label_nonzero = FALSE
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the simulations have been run with \code{\link[=generate_cells]{generate_cells()}}.}

\item{simulation_i}{Which simulation to visualise.}

\item{what}{Which molecule types to visualise.}

\item{facet}{What to facet on.}

\item{label_nonzero}{Plot labels for non-zero molecules.}
}
\value{
A ggplot2 object.
}
\description{
Visualise the expression of the simulations over simulation time
}
\examples{
\donttest{
data("example_model")
plot_simulation_expression(example_model)
}
}
