% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PF.R
\name{get_Q_0}
\alias{get_Q_0}
\title{Compute Time-Invariant Covariance Matrix}
\usage{
get_Q_0(Qmat, Fmat)
}
\arguments{
\item{Qmat}{covariance matrix in transition density.}

\item{Fmat}{coefficients in transition density.}
}
\value{
The invariant covariance matrix.
}
\description{
Computes the invariant covariance matrix for a vector autoregression model.
}
\examples{
Fmat <- matrix(c(.8, .4, .1, .5), 2, 2)
Qmat <- matrix(c( 1, .5, .5,  2), 2)

x1 <- get_Q_0(Qmat = Qmat, Fmat = Fmat)
x2 <- Qmat
for(i in 1:101)
  x2 <- tcrossprod(Fmat \%*\% x2, Fmat) + Qmat
stopifnot(isTRUE(all.equal(x1, x2)))


}
