% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_glm.R
\name{static_glm}
\alias{static_glm}
\title{Static glm Fit}
\usage{
static_glm(formula, data, by, max_T, ..., id, family = "logit",
  model = F, weights, risk_obj = NULL, speedglm = F,
  only_coef = FALSE, mf, method_use = c("glm", "speedglm",
  "parallelglm_quick", "parallelglm_QR"),
  n_threads = getOption("ddhazard_max_threads"))
}
\arguments{
\item{formula}{\code{\link[survival]{coxph}} like formula with \code{\link[survival]{Surv}(tstart, tstop, event)} on the left hand site of \code{~}.}

\item{data}{\code{data.frame} or environment containing the outcome and covariates.}

\item{by}{interval length of the bins in which parameters are fixed.}

\item{max_T}{end of the last interval interval.}

\item{...}{arguments passed to \code{\link{glm}} or \code{\link[speedglm]{speedglm}}. If \code{only_coef = TRUE} then the arguments are passed to \code{\link{glm.control}} if \code{\link{glm}} is used.}

\item{id}{vector of ids for each row of the in the design matrix.}

\item{family}{\code{"logit"}, \code{"cloglog"}, or \code{"exponential"} for a static equivalent model of \code{\link{ddhazard}}.}

\item{model}{\code{TRUE} if you want to save the design matrix used in \code{\link{glm}}.}

\item{weights}{weights to use if e.g. a skewed sample is used.}

\item{risk_obj}{a pre-computed result from a \code{\link{get_risk_obj}}. Will be used to skip some computations.}

\item{speedglm}{depreciated.}

\item{only_coef}{\code{TRUE} if only coefficients should be returned. This will only call the \code{speedglm::speedglm.wfit} or \code{\link{glm.fit}} which will be faster.}

\item{mf}{model matrix for regression. Needed when \code{only_coef = TRUE}}

\item{method_use}{method to use for estimation. \code{\link{glm}} uses \code{\link{glm.fit}}, \code{speedglm::speedglm} uses \code{speedglm::speedglm.wfit} and \code{parallelglm_quick} and \code{parallelglm_QR} uses a parallel \code{C++} estimation method.}

\item{n_threads}{number of threads to use when \code{method_use} is \code{"parallelglm"}.}
}
\value{
The returned list from the \code{\link{glm}} call or just coefficients depending on the value of \code{only_coef}.
}
\description{
Method to fit a static model corresponding to a \code{\link{ddhazard}} fit.
The method uses weights to ease the memory requirements. See
\code{\link{get_survival_case_weights_and_data}} for details on weights.

The \code{parallelglm_quick} and \code{parallelglm_QR} methods are similar
to two methods used in \code{bam} function in the \code{mgcv} package (see
the \code{`use.chol`} argument or Wood et al. 2015). \code{parallelglm_QR}
is more stable but slower. See Golub (2013) section 5.3 for a comparison of
the Cholesky decomposition method and the QR method.
}
\examples{
library(dynamichazard)
fit <- static_glm(
 Surv(time, status == 2) ~ log(bili), pbc, id = pbc$id, max_T = 3600,
 by = 50)
fit$coefficients


}
\references{
Wood, S.N., Goude, Y. & Shaw S. (2015) Generalized additive models for large datasets. Journal of the Royal Statistical Society, Series C 64(1): 139-155.

Golub, G. H., & Van Loan, C. F. (2013). Matrix computations (4th ed.). JHU Press.
}
