/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.GlassGradientPainter;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceBlendBiTheme;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.ClassicTitlePainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

public class AutumnSkin
extends SubstanceAbstractSkin {
    public static String NAME = "Autumn";

    public AutumnSkin() {
        SubstanceTheme activeTheme = new SubstanceTheme(new ActiveScheme(), "Autumn Active", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme defaultTheme = new SubstanceTheme(new DefaultScheme(), "Autumn Default", SubstanceTheme.ThemeKind.COLD);
        SubstanceBlendBiTheme disabledTheme = new SubstanceBlendBiTheme(defaultTheme, defaultTheme.getDisabledTheme(), 0.6);
        SubstanceTheme activeTitleTheme = defaultTheme;
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
        theme.setSelectedTabFadeStart(0.1);
        theme.setSelectedTabFadeEnd(0.3);
        this.theme = theme;
        this.shaper = new ClassicButtonShaper();
        this.watermark = new SubstanceNullWatermark();
        this.gradientPainter = new GlassGradientPainter();
        this.titlePainter = new ClassicTitlePainter();
        this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.75f);
    }

    public String getDisplayName() {
        return NAME;
    }

    protected static class DefaultScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = SubstanceColorUtilities.getFromHex("FFF2DF");
        private static final Color mainExtraLightColor = SubstanceColorUtilities.getFromHex("FFE3C5");
        private static final Color mainLightColor = SubstanceColorUtilities.getFromHex("FDD1A4");
        private static final Color mainMidColor = SubstanceColorUtilities.getFromHex("FBCD9C");
        private static final Color mainDarkColor = SubstanceColorUtilities.getFromHex("FCC896");
        private static final Color mainUltraDarkColor = SubstanceColorUtilities.getFromHex("872A00");
        private static final Color foregroundColor = SubstanceColorUtilities.getFromHex("2B0E00");

        protected DefaultScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class ActiveScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = SubstanceColorUtilities.getFromHex("FDDDAC");
        private static final Color mainExtraLightColor = SubstanceColorUtilities.getFromHex("FCEF9F");
        private static final Color mainLightColor = SubstanceColorUtilities.getFromHex("FCD592");
        private static final Color mainMidColor = SubstanceColorUtilities.getFromHex("F9BE84");
        private static final Color mainDarkColor = SubstanceColorUtilities.getFromHex("F8B87A");
        private static final Color mainUltraDarkColor = SubstanceColorUtilities.getFromHex("5B0E00");
        private static final Color foregroundColor = SubstanceColorUtilities.getFromHex("0A0000");

        protected ActiveScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

