/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.combo.SubstanceComboBoxRenderer;
import org.jvnet.substance.combo.SubstanceComboPopup;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceComboBoxUI
extends BasicComboBoxUI {
    protected Set lafWidgets;
    public static final Map<String, Icon> COMBO_ARROWS = new HashMap<String, Icon>();
    protected ComboBoxPropertyChangeHandler substanceChangeHandler;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();

    public void __org__jvnet__substance__SubstanceComboBoxUI__installDefaults() {
        super.installDefaults();
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__uninstallComponents() {
        super.uninstallComponents();
    }

    public void uninstallComponents() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite(jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceComboBoxUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceComboBoxUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__installComponents() {
        super.installComponents();
    }

    public void installComponents() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static synchronized void reset() {
        COMBO_ARROWS.clear();
    }

    public static synchronized Icon getArrowIcon(SubstanceTheme theme, int orientation) {
        String key = theme.getDisplayName() + ":" + orientation;
        Icon result = COMBO_ARROWS.get(key);
        if (result != null) {
            return result;
        }
        result = SubstanceImageCreator.getArrowIcon(9, orientation == 0 ? 12 : 6, orientation, theme);
        COMBO_ARROWS.put(key, result);
        return result;
    }

    public static ComponentUI createUI(JComponent b) {
        SubstanceComboBoxUI ui = new SubstanceComboBoxUI();
        return ui;
    }

    protected JButton createArrowButton() {
        SubstanceTheme theme = this.comboBox.isEnabled() ? SubstanceCoreUtilities.getActiveTheme(this.comboBox, true) : SubstanceCoreUtilities.getDefaultTheme(this.comboBox, true);
        return new SubstanceComboBoxButton(this.comboBox, SubstanceComboBoxUI.getArrowIcon(theme, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox)));
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    protected void __org__jvnet__substance__SubstanceComboBoxUI__installListeners() {
        super.installListeners();
        this.substanceChangeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.substanceChangeHandler);
    }

    protected void __org__jvnet__substance__SubstanceComboBoxUI__uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.substanceChangeHandler);
        this.substanceChangeHandler = null;
        super.uninstallListeners();
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension superRes = super.getPreferredSize(c);
        Dimension res = new Dimension((int)superRes.getWidth() + 4, (int)superRes.getHeight() + 4);
        return res;
    }

    protected ComboPopup createPopup() {
        final SubstanceComboPopup sPopup = new SubstanceComboPopup(this.comboBox);
        final ComponentOrientation currOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComboBoxEditor editor;
                ListCellRenderer cellRenderer;
                if (SubstanceComboBoxUI.this.comboBox == null) {
                    return;
                }
                if (sPopup instanceof Component) {
                    Component cPopup = (Component)((Object)sPopup);
                    cPopup.applyComponentOrientation(currOrientation);
                    cPopup.doLayout();
                }
                if ((cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer()) instanceof Component) {
                    ((Component)((Object)cellRenderer)).applyComponentOrientation(currOrientation);
                }
                if ((editor = SubstanceComboBoxUI.this.comboBox.getEditor()) != null && editor.getEditorComponent() instanceof Component) {
                    editor.getEditorComponent().applyComponentOrientation(currOrientation);
                }
                SubstanceComboBoxUI.this.comboBox.repaint();
            }
        });
        return sPopup;
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        SubstanceTheme theme = hasFocus ? SubstanceCoreUtilities.getActiveTheme(this.comboBox, true) : (this.comboBox.isEnabled() ? SubstanceCoreUtilities.getDefaultTheme(this.comboBox, true) : SubstanceCoreUtilities.getDisabledTheme(this.comboBox, true));
        Graphics2D graphics = (Graphics2D)g.create();
        if (!SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.comboBox)) {
            graphics.setComposite(TransitionLayout.getAlphaComposite(this.comboBox, 0.5f));
        }
        Rectangle newBounds = bounds;
        if (this.comboBox.getBorder() != null) {
            newBounds = new Rectangle(bounds.x, bounds.y + 1, bounds.width, bounds.height - 2);
        }
        backgroundDelegate.update(graphics, this.comboBox, newBounds, theme.getHighlightBackgroundTheme(), false);
        graphics.dispose();
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__update(Graphics g, JComponent c) {
        if (SubstanceCoreUtilities.hasSubstanceBorder(c)) {
            if (c.isOpaque()) {
                g.setColor(c.getBackground());
                g.fillRect(1, 1, c.getWidth() - 2, c.getHeight() - 2);
            }
            this.paint(g, c);
        } else {
            super.update(g, c);
        }
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceComboBoxUI: \n");
        sb.append("\t" + COMBO_ARROWS.size() + " arrows");
        return sb.toString();
    }

    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setFocusable(false);
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        public void propertyChange(final PropertyChangeEvent e) {
            SubstanceTheme theme;
            String propertyName = e.getPropertyName();
            if (propertyName.equals("enabled") && SubstanceComboBoxUI.this.arrowButton != null) {
                theme = SubstanceComboBoxUI.this.comboBox.isEnabled() ? SubstanceCoreUtilities.getActiveTheme(SubstanceComboBoxUI.this.comboBox, true) : SubstanceCoreUtilities.getDefaultTheme(SubstanceComboBoxUI.this.comboBox, true);
                SubstanceComboBoxUI.this.arrowButton.setIcon(SubstanceComboBoxUI.getArrowIcon(theme, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
            if (propertyName.equals("componentOrientation")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (SubstanceComboBoxUI.this.comboBox == null) {
                            return;
                        }
                        ComponentOrientation newOrientation = (ComponentOrientation)e.getNewValue();
                        SubstanceComboBoxUI.this.arrowButton.putClientProperty("substancelaf.buttonside", newOrientation.isLeftToRight() ? SubstanceConstants.Side.LEFT.name() : SubstanceConstants.Side.RIGHT.name());
                        ListCellRenderer cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                        ComboBoxEditor editor = SubstanceComboBoxUI.this.comboBox.getEditor();
                        if (SubstanceComboBoxUI.this.popup instanceof Component) {
                            Component cPopup = (Component)((Object)SubstanceComboBoxUI.this.popup);
                            cPopup.applyComponentOrientation(newOrientation);
                            cPopup.doLayout();
                        }
                        if (cellRenderer instanceof Component) {
                            ((Component)((Object)cellRenderer)).applyComponentOrientation(newOrientation);
                        }
                        if (editor != null && editor.getEditorComponent() instanceof Component) {
                            editor.getEditorComponent().applyComponentOrientation(newOrientation);
                        }
                        if (SubstanceComboBoxUI.this.comboBox != null) {
                            SubstanceComboBoxUI.this.comboBox.repaint();
                        }
                    }
                });
            }
            if ("substancelaf.comboboxpopupFlyoutOrientation".equals(propertyName)) {
                theme = SubstanceComboBoxUI.this.comboBox.isEnabled() ? SubstanceCoreUtilities.getActiveTheme(SubstanceComboBoxUI.this.comboBox, true) : SubstanceCoreUtilities.getDefaultTheme(SubstanceComboBoxUI.this.comboBox, true);
                SubstanceComboBoxUI.this.arrowButton.setIcon(SubstanceComboBoxUI.getArrowIcon(theme, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = SubstanceComboBoxUI.this.getInsets();
            int buttonWidth = UIManager.getInt("ScrollBar.width");
            int buttonHeight = height - (insets.top + insets.bottom);
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                SubstanceComboBoxUI.this.editor.setBounds(SubstanceComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

