/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetSupport;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.tabbed.TabOverviewButton;
import org.jvnet.lafwidget.tabbed.TabPreviewPainter;

public class TabOverviewDialogWidget
extends LafWidgetAdapter {
    protected TabOverviewButton overviewButton;
    protected JTabbedPane jtp;
    protected PropertyChangeListener propertyListener;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.jtp = (JTabbedPane)jcomp;
    }

    public void installComponents() {
        this.overviewButton = new TabOverviewButton(this.jtp);
    }

    public void installDefaults() {
        TabPreviewPainter previewPainter = LafWidgetUtilities.getTabPreviewPainter(this.jtp);
        if (previewPainter != null && previewPainter.hasOverviewDialog(this.jtp)) {
            LafWidgetSupport lafSupport = LafWidgetRepository.getRepository().getLafSupport();
            Insets currTabAreaInsets = lafSupport.getTabAreaInsets(this.jtp);
            if (currTabAreaInsets == null) {
                currTabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
            }
            Insets tabAreaInsets = new Insets(currTabAreaInsets.top, 18 + currTabAreaInsets.left, currTabAreaInsets.bottom, currTabAreaInsets.right);
            lafSupport.setTabAreaInsets(this.jtp, tabAreaInsets);
            this.jtp.add(this.overviewButton);
            this.overviewButton.setVisible(true);
            this.overviewButton.updateLocation(this.jtp, tabAreaInsets);
        }
    }

    public void uninstallComponents() {
        if (this.overviewButton.getParent() == this.jtp) {
            this.jtp.remove(this.overviewButton);
        }
    }

    public void installListeners() {
        this.propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Insets currTabAreaInsets;
                LafWidgetSupport lafSupport = LafWidgetRepository.getRepository().getLafSupport();
                Insets lafInsets = lafSupport.getTabAreaInsets(TabOverviewDialogWidget.this.jtp);
                Insets insets = currTabAreaInsets = lafInsets == null ? UIManager.getInsets("TabbedPane.tabAreaInsets") : lafInsets;
                if ("lafwidgets.tabbedpanePreviewPainter".equals(evt.getPropertyName())) {
                    TabPreviewPainter previewPainter = LafWidgetUtilities.getTabPreviewPainter(TabOverviewDialogWidget.this.jtp);
                    if (previewPainter != null && previewPainter.hasOverviewDialog(TabOverviewDialogWidget.this.jtp)) {
                        Insets tabAreaInsets = new Insets(currTabAreaInsets.top, 18 + currTabAreaInsets.left, currTabAreaInsets.bottom, currTabAreaInsets.right);
                        lafSupport.setTabAreaInsets(TabOverviewDialogWidget.this.jtp, tabAreaInsets);
                        TabOverviewDialogWidget.this.jtp.add(TabOverviewDialogWidget.this.overviewButton);
                        TabOverviewDialogWidget.this.overviewButton.setVisible(true);
                        TabOverviewDialogWidget.this.overviewButton.updateLocation(TabOverviewDialogWidget.this.jtp, tabAreaInsets);
                    } else {
                        TabOverviewDialogWidget.this.jtp.remove(TabOverviewDialogWidget.this.overviewButton);
                    }
                }
                if ("tabPlacement".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (TabOverviewDialogWidget.this.overviewButton.getParent() == TabOverviewDialogWidget.this.jtp) {
                                TabOverviewDialogWidget.this.overviewButton.updateLocation(TabOverviewDialogWidget.this.jtp, currTabAreaInsets);
                            }
                        }
                    });
                }
                if ("componentOrientation".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (TabOverviewDialogWidget.this.overviewButton.getParent() == TabOverviewDialogWidget.this.jtp) {
                                TabOverviewDialogWidget.this.overviewButton.updateLocation(TabOverviewDialogWidget.this.jtp, currTabAreaInsets);
                            }
                        }
                    });
                }
            }
        };
        this.jtp.addPropertyChangeListener(this.propertyListener);
    }

    public void uninstallListeners() {
        this.jtp.removePropertyChangeListener(this.propertyListener);
        this.propertyListener = null;
    }

    public boolean requiresCustomLafSupport() {
        return true;
    }
}

