/*
 * Decompiled with CFR 0.152.
 */
package contrib.ch.randelshofer.quaqua.colorchooser;

import contrib.ch.randelshofer.quaqua.colorchooser.CMYKChooser;
import contrib.ch.randelshofer.quaqua.colorchooser.GrayChooser;
import contrib.ch.randelshofer.quaqua.colorchooser.HSBChooser;
import contrib.ch.randelshofer.quaqua.colorchooser.HTMLChooser;
import contrib.ch.randelshofer.quaqua.colorchooser.RGBChooser;
import contrib.ch.randelshofer.quaqua.util.ResourceBundleUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.UIResource;

public class ColorSlidersChooser
extends AbstractColorChooserPanel
implements UIResource {
    private ResourceBundleUtil labels = (ResourceBundleUtil)UIManager.get("Labels");
    private static int lastSelectedPanelIndex = 1;
    private JComboBox slidersComboBox;
    private JPanel slidersHolder;

    public ColorSlidersChooser() {
        this.initComponents();
        this.slidersComboBox.setFont(UIManager.getFont("ColorChooser.font"));
    }

    private void initComponents() {
        this.slidersComboBox = new JComboBox();
        this.slidersHolder = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.slidersComboBox, "North");
        this.slidersHolder.setLayout(new CardLayout());
        this.add((Component)this.slidersHolder, "Center");
    }

    protected void buildChooser() {
        this.slidersHolder.add((Component)new GrayChooser(), this.labels.getString("ColorChooser.grayScaleSlider"));
        this.slidersHolder.add((Component)new RGBChooser(), this.labels.getString("ColorChooser.rgbSliders"));
        this.slidersHolder.add((Component)new CMYKChooser(), this.labels.getString("ColorChooser.cmykSliders"));
        this.slidersHolder.add((Component)new HSBChooser(), this.labels.getString("ColorChooser.hsbSliders"));
        this.slidersHolder.add((Component)new HTMLChooser(), this.labels.getString("ColorChooser.htmlSliders"));
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>();
        cbm.addElement(this.labels.getString("ColorChooser.grayScaleSlider"));
        cbm.addElement(this.labels.getString("ColorChooser.rgbSliders"));
        cbm.addElement(this.labels.getString("ColorChooser.cmykSliders"));
        cbm.addElement(this.labels.getString("ColorChooser.hsbSliders"));
        cbm.addElement(this.labels.getString("ColorChooser.htmlSliders"));
        this.slidersComboBox.setModel(cbm);
        this.slidersComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    ((CardLayout)ColorSlidersChooser.this.slidersHolder.getLayout()).show(ColorSlidersChooser.this.slidersHolder, (String)evt.getItem());
                    lastSelectedPanelIndex = ColorSlidersChooser.this.slidersComboBox.getSelectedIndex();
                }
            }
        });
        this.slidersComboBox.setSelectedIndex(lastSelectedPanelIndex);
    }

    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
        Component[] components = this.slidersHolder.getComponents();
        for (int i = 0; i < components.length; ++i) {
            AbstractColorChooserPanel ccp = (AbstractColorChooserPanel)components[i];
            ccp.installChooserPanel(enclosingChooser);
        }
    }

    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        Component[] components = this.slidersHolder.getComponents();
        for (int i = 0; i < components.length; ++i) {
            AbstractColorChooserPanel ccp = (AbstractColorChooserPanel)components[i];
            ccp.uninstallChooserPanel(enclosingChooser);
        }
        super.uninstallChooserPanel(enclosingChooser);
    }

    public String getDisplayName() {
        return this.labels.getString("ColorChooser.colorSliders");
    }

    public Icon getLargeDisplayIcon() {
        return UIManager.getIcon("ColorChooser.colorSlidersIcon");
    }

    public Icon getSmallDisplayIcon() {
        return this.getLargeDisplayIcon();
    }

    public void updateChooser() {
    }
}

