/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.DomainInfo;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.KeyedValues;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DefaultVectorDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.experimental.data.xy.VectorXYDataset;
import org.jfree.util.ArrayUtilities;

public final class myDatasetUtilities {
    private myDatasetUtilities() {
    }

    public static double calculateVectorDatasetTotal(VectorXYDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double max = 0.0;
        int i = 0;
        while (i < dataset.getItemCount(0)) {
            double x = dataset.getDeltaXValue(0, i);
            double y = dataset.getDeltaXValue(0, i);
            if ((x = Math.abs(x)) * (y = Math.abs(y)) > max) {
                max = x * y;
            }
            ++i;
        }
        return max;
    }

    public static VectorXYDataset createVectorDatasetForRow(CategoryDataset dataset, Comparable rowKey) {
        int row = dataset.getRowIndex(rowKey);
        return myDatasetUtilities.createVectorDatasetForRow(dataset, row);
    }

    public static VectorXYDataset createVectorDatasetForRow(CategoryDataset dataset, int row) {
        DefaultVectorDataset result = new DefaultVectorDataset();
        int columnCount = dataset.getColumnCount();
        int current = 0;
        while (current < columnCount) {
            Comparable columnKey = dataset.getColumnKey(current);
            result.setValue(columnKey, dataset.getValue(row, current));
            ++current;
        }
        return result;
    }

    public static VectorXYDataset createPieDatasetForColumn(CategoryDataset dataset, Comparable columnKey) {
        int column = dataset.getColumnIndex(columnKey);
        return myDatasetUtilities.createVectorDatasetForColumn(dataset, column);
    }

    public static VectorXYDataset createVectorDatasetForColumn(CategoryDataset dataset, int column) {
        DefaultVectorDataset result = new DefaultVectorDataset();
        int rowCount = dataset.getRowCount();
        int i = 0;
        while (i < rowCount) {
            Comparable rowKey = dataset.getRowKey(i);
            result.setValue(rowKey, dataset.getValue(i, column));
            ++i;
        }
        return result;
    }

    public static VectorXYDataset createConsolidatedVectorDataset(VectorXYDataset source, Comparable key, double minimumPercent) {
        return myDatasetUtilities.createConsolidatedVectorDataset(source, key, minimumPercent, 2);
    }

    public static VectorXYDataset createConsolidatedVectorDataset(VectorXYDataset source, Comparable key, double minimumPercent, int minItems) {
        DefaultVectorDataset result = new DefaultVectorDataset();
        double total = myDatasetUtilities.calculateVectorDatasetTotal(source);
        List keys = source.getKeys();
        ArrayList<Comparable> otherKeys = new ArrayList<Comparable>();
        for (Comparable currentKey : keys) {
            double value;
            Number dataValue = source.getValue(currentKey);
            if (dataValue == null || !((value = dataValue.doubleValue()) / total < minimumPercent)) continue;
            otherKeys.add(currentKey);
        }
        Iterator iterator = keys.iterator();
        double otherValue = 0.0;
        while (iterator.hasNext()) {
            Comparable currentKey = (Comparable)iterator.next();
            Number dataValue = source.getValue(currentKey);
            if (dataValue == null) continue;
            if (otherKeys.contains(currentKey) && otherKeys.size() >= minItems) {
                otherValue += dataValue.doubleValue();
                continue;
            }
            result.setValue(currentKey, dataValue);
        }
        if (otherKeys.size() >= minItems) {
            result.setValue(key, otherValue);
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(String rowKeyPrefix, String columnKeyPrefix, double[][] data) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        int r = 0;
        while (r < data.length) {
            String rowKey = String.valueOf(rowKeyPrefix) + (r + 1);
            int c = 0;
            while (c < data[r].length) {
                String columnKey = String.valueOf(columnKeyPrefix) + (c + 1);
                result.addValue(new Double(data[r][c]), (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
                ++c;
            }
            ++r;
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(String rowKeyPrefix, String columnKeyPrefix, Number[][] data) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        int r = 0;
        while (r < data.length) {
            String rowKey = String.valueOf(rowKeyPrefix) + (r + 1);
            int c = 0;
            while (c < data[r].length) {
                String columnKey = String.valueOf(columnKeyPrefix) + (c + 1);
                result.addValue(data[r][c], (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
                ++c;
            }
            ++r;
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(Comparable[] rowKeys, Comparable[] columnKeys, double[][] data) {
        if (rowKeys == null) {
            throw new IllegalArgumentException("Null 'rowKeys' argument.");
        }
        if (columnKeys == null) {
            throw new IllegalArgumentException("Null 'columnKeys' argument.");
        }
        if (ArrayUtilities.hasDuplicateItems(rowKeys)) {
            throw new IllegalArgumentException("Duplicate items in 'rowKeys'.");
        }
        if (ArrayUtilities.hasDuplicateItems(columnKeys)) {
            throw new IllegalArgumentException("Duplicate items in 'columnKeys'.");
        }
        if (rowKeys.length != data.length) {
            throw new IllegalArgumentException("The number of row keys does not match the number of rows in the data array.");
        }
        int columnCount = 0;
        int r = 0;
        while (r < data.length) {
            columnCount = Math.max(columnCount, data[r].length);
            ++r;
        }
        if (columnKeys.length != columnCount) {
            throw new IllegalArgumentException("The number of column keys does not match the number of columns in the data array.");
        }
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        int r2 = 0;
        while (r2 < data.length) {
            Comparable rowKey = rowKeys[r2];
            int c = 0;
            while (c < data[r2].length) {
                Comparable columnKey = columnKeys[c];
                result.addValue(new Double(data[r2][c]), rowKey, columnKey);
                ++c;
            }
            ++r2;
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(Comparable rowKey, KeyedValues rowData) {
        if (rowKey == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (rowData == null) {
            throw new IllegalArgumentException("Null 'rowData' argument.");
        }
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        int i = 0;
        while (i < rowData.getItemCount()) {
            result.addValue(rowData.getValue(i), rowKey, rowData.getKey(i));
            ++i;
        }
        return result;
    }

    public static XYDataset sampleFunction2D(Function2D f, double start, double end, int samples, Comparable seriesKey) {
        if (f == null) {
            throw new IllegalArgumentException("Null 'f' argument.");
        }
        if (seriesKey == null) {
            throw new IllegalArgumentException("Null 'seriesKey' argument.");
        }
        if (start >= end) {
            throw new IllegalArgumentException("Requires 'start' < 'end'.");
        }
        if (samples < 2) {
            throw new IllegalArgumentException("Requires 'samples' > 1");
        }
        XYSeries series = new XYSeries(seriesKey);
        double step = (end - start) / (double)samples;
        int i = 0;
        while (i <= samples) {
            double x = start + step * (double)i;
            series.add(x, f.getValue(x));
            ++i;
        }
        XYSeriesCollection collection = new XYSeriesCollection(series);
        return collection;
    }

    public static boolean isEmptyOrNull(VectorXYDataset dataset) {
        if (dataset == null) {
            return true;
        }
        int itemCount = dataset.getItemCount();
        if (itemCount == 0) {
            return true;
        }
        int item = 0;
        while (item < itemCount) {
            double yy;
            Number y = dataset.getValue(item);
            if (y != null && (yy = y.doubleValue()) > 0.0) {
                return false;
            }
            ++item;
        }
        return true;
    }

    public static boolean isEmptyOrNull(CategoryDataset dataset) {
        if (dataset == null) {
            return true;
        }
        int rowCount = dataset.getRowCount();
        int columnCount = dataset.getColumnCount();
        if (rowCount == 0 || columnCount == 0) {
            return true;
        }
        int r = 0;
        while (r < rowCount) {
            int c = 0;
            while (c < columnCount) {
                if (dataset.getValue(r, c) != null) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public static boolean isEmptyOrNull(XYDataset dataset) {
        boolean result = true;
        if (dataset != null) {
            int s = 0;
            while (s < dataset.getSeriesCount()) {
                if (dataset.getItemCount(s) > 0) {
                    result = false;
                }
                ++s;
            }
        }
        return result;
    }

    public static Range findDomainBounds(XYDataset dataset) {
        return myDatasetUtilities.findDomainBounds(dataset, true);
    }

    public static Range findDomainBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        if (dataset instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)dataset);
            result = info.getDomainBounds(includeInterval);
        } else {
            result = myDatasetUtilities.iterateDomainBounds(dataset, includeInterval);
        }
        return result;
    }

    public static Range iterateDomainBounds(XYDataset dataset) {
        return myDatasetUtilities.iterateDomainBounds(dataset, true);
    }

    public static Range iterateDomainBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        if (includeInterval && dataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue = intervalXYData.getStartXValue(series, item);
                    double uvalue = intervalXYData.getEndXValue(series, item);
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                    ++item;
                }
                ++series;
            }
        } else {
            int series = 0;
            while (series < seriesCount) {
                int itemCount = dataset.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    double lvalue;
                    double uvalue = lvalue = dataset.getXValue(series, item);
                    minimum = Math.min(minimum, lvalue);
                    maximum = Math.max(maximum, uvalue);
                    ++item;
                }
                ++series;
            }
        }
        if (minimum > maximum) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range findRangeBounds(CategoryDataset dataset) {
        return myDatasetUtilities.findRangeBounds(dataset, true);
    }

    public static Range findRangeBounds(CategoryDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        if (dataset instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)dataset);
            result = info.getRangeBounds(includeInterval);
        } else {
            result = myDatasetUtilities.iterateCategoryRangeBounds(dataset, includeInterval);
        }
        return result;
    }

    public static Range findRangeBounds(XYDataset dataset) {
        return myDatasetUtilities.findRangeBounds(dataset, true);
    }

    public static Range findRangeBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        if (dataset instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)dataset);
            result = info.getRangeBounds(includeInterval);
        } else {
            result = myDatasetUtilities.iterateXYRangeBounds(dataset);
        }
        return result;
    }

    public static Range iterateCategoryRangeBounds(CategoryDataset dataset, boolean includeInterval) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        boolean interval = includeInterval && dataset instanceof IntervalCategoryDataset;
        int rowCount = dataset.getRowCount();
        int columnCount = dataset.getColumnCount();
        int row = 0;
        while (row < rowCount) {
            int column = 0;
            while (column < columnCount) {
                Number uvalue;
                Number lvalue;
                if (interval) {
                    IntervalCategoryDataset icd = (IntervalCategoryDataset)dataset;
                    lvalue = icd.getStartValue(row, column);
                    uvalue = icd.getEndValue(row, column);
                } else {
                    uvalue = lvalue = dataset.getValue(row, column);
                }
                if (lvalue != null) {
                    minimum = Math.min(minimum, lvalue.doubleValue());
                }
                if (uvalue != null) {
                    maximum = Math.max(maximum, uvalue.doubleValue());
                }
                ++column;
            }
            ++row;
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range iterateXYRangeBounds(XYDataset dataset) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        int series = 0;
        while (series < seriesCount) {
            int itemCount = dataset.getItemCount(series);
            int item = 0;
            while (item < itemCount) {
                double uvalue;
                double lvalue;
                if (dataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
                    lvalue = intervalXYData.getStartYValue(series, item);
                    uvalue = intervalXYData.getEndYValue(series, item);
                } else if (dataset instanceof OHLCDataset) {
                    OHLCDataset highLowData = (OHLCDataset)dataset;
                    lvalue = highLowData.getLowValue(series, item);
                    uvalue = highLowData.getHighValue(series, item);
                } else {
                    uvalue = lvalue = dataset.getYValue(series, item);
                }
                if (!Double.isNaN(lvalue)) {
                    minimum = Math.min(minimum, lvalue);
                }
                if (!Double.isNaN(uvalue)) {
                    maximum = Math.max(maximum, uvalue);
                }
                ++item;
            }
            ++series;
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Number findMinimumDomainValue(XYDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Double result = null;
        if (dataset instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)dataset);
            return new Double(info.getDomainLowerBound(true));
        }
        double minimum = Double.POSITIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        int series = 0;
        while (series < seriesCount) {
            int itemCount = dataset.getItemCount(series);
            int item = 0;
            while (item < itemCount) {
                double value;
                if (dataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
                    value = intervalXYData.getStartXValue(series, item);
                } else {
                    value = dataset.getXValue(series, item);
                }
                if (!Double.isNaN(value)) {
                    minimum = Math.min(minimum, value);
                }
                ++item;
            }
            ++series;
        }
        result = minimum == Double.POSITIVE_INFINITY ? null : new Double(minimum);
        return result;
    }

    public static Number findMaximumDomainValue(XYDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Double result = null;
        if (dataset instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)dataset);
            return new Double(info.getDomainUpperBound(true));
        }
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        int series = 0;
        while (series < seriesCount) {
            int itemCount = dataset.getItemCount(series);
            int item = 0;
            while (item < itemCount) {
                double value;
                if (dataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
                    value = intervalXYData.getEndXValue(series, item);
                } else {
                    value = dataset.getXValue(series, item);
                }
                if (!Double.isNaN(value)) {
                    maximum = Math.max(maximum, value);
                }
                ++item;
            }
            ++series;
        }
        result = maximum == Double.NEGATIVE_INFINITY ? null : new Double(maximum);
        return result;
    }

    public static Number findMinimumRangeValue(CategoryDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)dataset);
            return new Double(info.getRangeLowerBound(true));
        }
        double minimum = Double.POSITIVE_INFINITY;
        int seriesCount = dataset.getRowCount();
        int itemCount = dataset.getColumnCount();
        int series = 0;
        while (series < seriesCount) {
            int item = 0;
            while (item < itemCount) {
                Number value;
                if (dataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset icd = (IntervalCategoryDataset)dataset;
                    value = icd.getStartValue(series, item);
                } else {
                    value = dataset.getValue(series, item);
                }
                if (value != null) {
                    minimum = Math.min(minimum, value.doubleValue());
                }
                ++item;
            }
            ++series;
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(minimum);
    }

    public static Number findMinimumRangeValue(XYDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)dataset);
            return new Double(info.getRangeLowerBound(true));
        }
        double minimum = Double.POSITIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        int series = 0;
        while (series < seriesCount) {
            int itemCount = dataset.getItemCount(series);
            int item = 0;
            while (item < itemCount) {
                double value;
                if (dataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
                    value = intervalXYData.getStartYValue(series, item);
                } else if (dataset instanceof OHLCDataset) {
                    OHLCDataset highLowData = (OHLCDataset)dataset;
                    value = highLowData.getLowValue(series, item);
                } else {
                    value = dataset.getYValue(series, item);
                }
                if (!Double.isNaN(value)) {
                    minimum = Math.min(minimum, value);
                }
                ++item;
            }
            ++series;
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(minimum);
    }

    public static Number findMaximumRangeValue(CategoryDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)dataset);
            return new Double(info.getRangeUpperBound(true));
        }
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getRowCount();
        int itemCount = dataset.getColumnCount();
        int series = 0;
        while (series < seriesCount) {
            int item = 0;
            while (item < itemCount) {
                Number value;
                if (dataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset icd = (IntervalCategoryDataset)dataset;
                    value = icd.getEndValue(series, item);
                } else {
                    value = dataset.getValue(series, item);
                }
                if (value != null) {
                    maximum = Math.max(maximum, value.doubleValue());
                }
                ++item;
            }
            ++series;
        }
        if (maximum == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(maximum);
    }

    public static Number findMaximumRangeValue(XYDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)dataset);
            return new Double(info.getRangeUpperBound(true));
        }
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = dataset.getSeriesCount();
        int series = 0;
        while (series < seriesCount) {
            int itemCount = dataset.getItemCount(series);
            int item = 0;
            while (item < itemCount) {
                double value;
                if (dataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
                    value = intervalXYData.getEndYValue(series, item);
                } else if (dataset instanceof OHLCDataset) {
                    OHLCDataset highLowData = (OHLCDataset)dataset;
                    value = highLowData.getHighValue(series, item);
                } else {
                    value = dataset.getYValue(series, item);
                }
                if (!Double.isNaN(value)) {
                    maximum = Math.max(maximum, value);
                }
                ++item;
            }
            ++series;
        }
        if (maximum == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(maximum);
    }

    public static Range findStackedRangeBounds(CategoryDataset dataset) {
        return myDatasetUtilities.findStackedRangeBounds(dataset, 0.0);
    }

    public static Range findStackedRangeBounds(CategoryDataset dataset, double base) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range result = null;
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int categoryCount = dataset.getColumnCount();
        int item = 0;
        while (item < categoryCount) {
            double positive = base;
            double negative = base;
            int seriesCount = dataset.getRowCount();
            int series = 0;
            while (series < seriesCount) {
                Number number = dataset.getValue(series, item);
                if (number != null) {
                    double value = number.doubleValue();
                    if (value > 0.0) {
                        positive += value;
                    }
                    if (value < 0.0) {
                        negative += value;
                    }
                }
                ++series;
            }
            minimum = Math.min(minimum, negative);
            maximum = Math.max(maximum, positive);
            ++item;
        }
        if (minimum <= maximum) {
            result = new Range(minimum, maximum);
        }
        return result;
    }

    public static Range findStackedRangeBounds(CategoryDataset dataset, KeyToGroupMap map) {
        Range result = null;
        if (dataset != null) {
            int[] groupIndex = new int[dataset.getRowCount()];
            int i = 0;
            while (i < dataset.getRowCount()) {
                groupIndex[i] = map.getGroupIndex(map.getGroup(dataset.getRowKey(i)));
                ++i;
            }
            int groupCount = map.getGroupCount();
            double[] minimum = new double[groupCount];
            double[] maximum = new double[groupCount];
            int categoryCount = dataset.getColumnCount();
            int item = 0;
            while (item < categoryCount) {
                double[] positive = new double[groupCount];
                double[] negative = new double[groupCount];
                int seriesCount = dataset.getRowCount();
                int series = 0;
                while (series < seriesCount) {
                    Number number = dataset.getValue(series, item);
                    if (number != null) {
                        double value = number.doubleValue();
                        if (value > 0.0) {
                            positive[groupIndex[series]] = positive[groupIndex[series]] + value;
                        }
                        if (value < 0.0) {
                            negative[groupIndex[series]] = negative[groupIndex[series]] + value;
                        }
                    }
                    ++series;
                }
                int g = 0;
                while (g < groupCount) {
                    minimum[g] = Math.min(minimum[g], negative[g]);
                    maximum[g] = Math.max(maximum[g], positive[g]);
                    ++g;
                }
                ++item;
            }
            int j = 0;
            while (j < groupCount) {
                result = Range.combine(result, new Range(minimum[j], maximum[j]));
                ++j;
            }
        }
        return result;
    }

    public static Number findMinimumStackedRangeValue(CategoryDataset dataset) {
        Double result = null;
        if (dataset != null) {
            double minimum = 0.0;
            int categoryCount = dataset.getRowCount();
            int item = 0;
            while (item < categoryCount) {
                double total = 0.0;
                int seriesCount = dataset.getColumnCount();
                int series = 0;
                while (series < seriesCount) {
                    double value;
                    Number number = dataset.getValue(series, item);
                    if (number != null && (value = number.doubleValue()) < 0.0) {
                        total += value;
                    }
                    ++series;
                }
                minimum = Math.min(minimum, total);
                ++item;
            }
            result = new Double(minimum);
        }
        return result;
    }

    public static Number findMaximumStackedRangeValue(CategoryDataset dataset) {
        Double result = null;
        if (dataset != null) {
            double maximum = 0.0;
            int categoryCount = dataset.getColumnCount();
            int item = 0;
            while (item < categoryCount) {
                double total = 0.0;
                int seriesCount = dataset.getRowCount();
                int series = 0;
                while (series < seriesCount) {
                    double value;
                    Number number = dataset.getValue(series, item);
                    if (number != null && (value = number.doubleValue()) > 0.0) {
                        total += value;
                    }
                    ++series;
                }
                maximum = Math.max(maximum, total);
                ++item;
            }
            result = new Double(maximum);
        }
        return result;
    }

    public static Range findStackedRangeBounds(TableXYDataset dataset) {
        return myDatasetUtilities.findStackedRangeBounds(dataset, 0.0);
    }

    public static Range findStackedRangeBounds(TableXYDataset dataset, double base) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double minimum = base;
        double maximum = base;
        int itemNo = 0;
        while (itemNo < dataset.getItemCount()) {
            double positive = base;
            double negative = base;
            int seriesCount = dataset.getSeriesCount();
            int seriesNo = 0;
            while (seriesNo < seriesCount) {
                double y = dataset.getYValue(seriesNo, itemNo);
                if (!Double.isNaN(y)) {
                    if (y > 0.0) {
                        positive += y;
                    } else {
                        negative += y;
                    }
                }
                ++seriesNo;
            }
            if (positive > maximum) {
                maximum = positive;
            }
            if (negative < minimum) {
                minimum = negative;
            }
            ++itemNo;
        }
        if (minimum <= maximum) {
            return new Range(minimum, maximum);
        }
        return null;
    }

    public static double calculateStackTotal(TableXYDataset dataset, int item) {
        double total = 0.0;
        int seriesCount = dataset.getSeriesCount();
        int s = 0;
        while (s < seriesCount) {
            double value = dataset.getYValue(s, item);
            if (!Double.isNaN(value)) {
                total += value;
            }
            ++s;
        }
        return total;
    }

    public static Range findCumulativeRangeBounds(CategoryDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        boolean allItemsNull = true;
        double minimum = 0.0;
        double maximum = 0.0;
        int row = 0;
        while (row < dataset.getRowCount()) {
            double runningTotal = 0.0;
            int column = 0;
            while (column < dataset.getColumnCount() - 1) {
                Number n = dataset.getValue(row, column);
                if (n != null) {
                    allItemsNull = false;
                    double value = n.doubleValue();
                    minimum = Math.min(minimum, runningTotal += value);
                    maximum = Math.max(maximum, runningTotal);
                }
                ++column;
            }
            ++row;
        }
        if (!allItemsNull) {
            return new Range(minimum, maximum);
        }
        return null;
    }
}

