/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public class SetMapMode
extends EMFTag
implements EMFConstants {
    private int mode;

    public SetMapMode() {
        super(17, 1);
    }

    public SetMapMode(int mode) {
        this();
        this.mode = mode;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        return new SetMapMode(emf.readDWORD());
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeDWORD(this.mode);
    }

    public String toString() {
        return super.toString() + "\n  mode: " + this.mode;
    }

    public void render(EMFRenderer renderer) {
        if (this.mode == 8) {
            renderer.setMapModeIsotropic(false);
        } else if (this.mode == 5) {
            double scale = 0.0254;
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(scale, scale));
        } else if (this.mode == 3) {
            double scale = 0.01;
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(scale, scale));
        } else if (this.mode == 7) {
            renderer.setMapModeIsotropic(true);
            renderer.fixViewportSize();
        } else if (this.mode == 4) {
            double scale = 0.254;
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(scale, scale));
        } else if (this.mode == 2) {
            double scale = 0.1;
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(scale, scale));
        } else if (this.mode == 1) {
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        } else if (this.mode == 6) {
            renderer.setMapModeTransform(AffineTransform.getScaleInstance(EMFRenderer.TWIP_SCALE, EMFRenderer.TWIP_SCALE));
        }
    }
}

