/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.xy.AbstractXYZDataset;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.XYZDataset;

public class DatasetCreator {
    public static final String cars = "Cars";
    public static final String trucks = "Trucks";
    public static final String buses = "Buses";
    public static final String newCarSales = "New car sales";
    public static final String usedCarSales = "Used car sales";
    public static final String leasing = "Leasing";
    public static final String service = "Service";
    public static final String others = "Others";

    public static DefaultCategoryDataset createDefaultCategoryDataset() {
        return DatasetCreator.createDefaultCategoryDataset(-1, -1);
    }

    public static DefaultCategoryDataset createDefaultCategoryDataset(int start, int end) {
        if (start == -1 && end == -1) {
            start = 0;
            end = 3;
        }
        if (start < 0) {
            throw new IllegalArgumentException();
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = start;
        while (i < end) {
            switch (i) {
                case 0: {
                    dataset.addValue(50000.0, (Comparable)((Object)cars), (Comparable)((Object)newCarSales));
                    dataset.addValue(25000.0, (Comparable)((Object)cars), (Comparable)((Object)usedCarSales));
                    dataset.addValue(30000.0, (Comparable)((Object)cars), (Comparable)((Object)leasing));
                    dataset.addValue(40000.0, (Comparable)((Object)cars), (Comparable)((Object)service));
                    dataset.addValue(5000.0, (Comparable)((Object)cars), (Comparable)((Object)others));
                    break;
                }
                case 1: {
                    dataset.addValue(20000.0, (Comparable)((Object)trucks), (Comparable)((Object)newCarSales));
                    dataset.addValue(30000.0, (Comparable)((Object)trucks), (Comparable)((Object)usedCarSales));
                    dataset.addValue(15000.0, (Comparable)((Object)trucks), (Comparable)((Object)leasing));
                    dataset.addValue(25000.0, (Comparable)((Object)trucks), (Comparable)((Object)service));
                    dataset.addValue(10000.0, (Comparable)((Object)trucks), (Comparable)((Object)others));
                    break;
                }
                case 2: {
                    dataset.addValue(10000.0, (Comparable)((Object)buses), (Comparable)((Object)newCarSales));
                    dataset.addValue(1000.0, (Comparable)((Object)buses), (Comparable)((Object)usedCarSales));
                    dataset.addValue(20000.0, (Comparable)((Object)buses), (Comparable)((Object)leasing));
                    dataset.addValue(25000.0, (Comparable)((Object)buses), (Comparable)((Object)service));
                    dataset.addValue(2000.0, (Comparable)((Object)buses), (Comparable)((Object)others));
                    break;
                }
                default: {
                    String key = Integer.toString(i);
                    dataset.addValue(10000.0 * (Math.sin(0.3 * (double)i) + 1.0), (Comparable)((Object)key), (Comparable)((Object)newCarSales));
                    dataset.addValue(10000.0 * (Math.sin(0.7 * (double)i) + 1.0), (Comparable)((Object)key), (Comparable)((Object)usedCarSales));
                    dataset.addValue(10000.0 * (Math.sin(0.9 * (double)i) + 1.0), (Comparable)((Object)key), (Comparable)((Object)leasing));
                    dataset.addValue(10000.0 * (Math.sin(1.2 * (double)i) + 1.0), (Comparable)((Object)key), (Comparable)((Object)service));
                    dataset.addValue(10000.0 * (Math.sin(1.9 * (double)i) + 1.0), (Comparable)((Object)key), (Comparable)((Object)others));
                }
            }
            ++i;
        }
        return dataset;
    }

    public static PieDataset createPieDataset() {
        PieDataset dataset = DatasetUtilities.createPieDatasetForRow((CategoryDataset)DatasetCreator.createDefaultCategoryDataset(), (Comparable)((Object)cars));
        return dataset;
    }

    public static DefaultHighLowDataset createDefaultHighLowDataset(int size) {
        Date[] date = new Date[size];
        double[] high = new double[size];
        double[] low = new double[size];
        double[] open = new double[size];
        double[] close = new double[size];
        double[] volume = new double[size];
        int i = 0;
        while (i < size) {
            date[i] = DatasetCreator.date(2006, 1, i + 1);
            double base = 1000.0 + (Math.sin(0.1 * (double)i) + 1.0) * 2000.0;
            double udiff = (0.1 + (Math.sin(11.0 * (double)i) + 1.0)) * 500.0;
            double bdiff = (Math.sin(29.0 * (double)i) + 1.0) * 500.0;
            double diff = udiff - bdiff;
            high[i] = base + udiff;
            low[i] = base + bdiff;
            open[i] = low[i] + (Math.sin(103 * i) + 1.0) / 2.0 * diff;
            close[i] = low[i] + (Math.sin(137 * i) + 1.0) / 2.0 * diff;
            volume[i] = 10000.0 + (Math.sin(0.1 * (double)i) + Math.sin(7 * i) + 2.0) * 7000.0;
            ++i;
        }
        return new DefaultHighLowDataset((Comparable)((Object)"foo Inc."), date, high, low, open, close, volume);
    }

    private static Date date(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static IntervalCategoryDataset createTaskSeriesCollection() {
        String Task1 = "Task 1";
        String Task2 = "Task 2";
        String Task3 = "Task 3";
        String Task4 = "Task 4";
        TaskSeriesCollection collection = new TaskSeriesCollection();
        TaskSeries s = new TaskSeries("Scheduled");
        s.add(new Task(Task1, new SimpleTimePeriod(DatasetCreator.date(2006, 3, 1), DatasetCreator.date(2006, 3, 15))));
        s.add(new Task(Task2, new Day(DatasetCreator.date(2006, 3, 20))));
        s.add(new Task(Task3, DatasetCreator.date(2006, 3, 25), DatasetCreator.date(2006, 4, 10)));
        s.add(new Task(Task4, DatasetCreator.date(2006, 4, 13), DatasetCreator.date(2006, 4, 15)));
        collection.add(s);
        s = new TaskSeries("Actual");
        s.add(new Task(Task1, new SimpleTimePeriod(DatasetCreator.date(2006, 3, 1), DatasetCreator.date(2006, 3, 20))));
        s.add(new Task(Task2, new Day(DatasetCreator.date(2006, 4, 7))));
        s.add(new Task(Task3, DatasetCreator.date(2006, 4, 10), DatasetCreator.date(2006, 4, 20)));
        s.add(new Task(Task4, DatasetCreator.date(2006, 4, 21), DatasetCreator.date(2006, 4, 23)));
        collection.add(s);
        return collection;
    }

    public static BoxAndWhiskerCategoryDataset createBoxAndWhiskerCategoryDataset(int rowCount, int columnCount) {
        int entityCount = 10;
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        int rowIndex = 0;
        while (rowIndex < rowCount) {
            int columnIndex = 0;
            while (columnIndex < columnCount) {
                ArrayList<Double> list = new ArrayList<Double>();
                int entityIndex = 0;
                while (entityIndex < 10) {
                    double v = 100.0 + (double)((rowIndex + columnIndex * 11 + entityIndex * 13) % 7 * 10) + Math.sin((double)rowIndex * 0.1 + (double)columnIndex * 0.3 + (double)entityIndex * 0.5) * 50.0;
                    list.add(new Double(v));
                    ++entityIndex;
                }
                dataset.add(list, (Comparable)((Object)("Row " + Integer.toString(rowIndex))), (Comparable)((Object)("Column " + Integer.toString(columnIndex))));
                ++columnIndex;
            }
            ++rowIndex;
        }
        return dataset;
    }

    public static XYZDataset createXYZDataset() {
        return new SampleXYZDataset();
    }

    public static XYZDataset createXYZDataset(int seriesCount, int itemCount) {
        return new SampleXYZDataset(seriesCount, itemCount);
    }

    private static class SampleXYZDataset
    extends AbstractXYZDataset
    implements XYZDataset {
        private static final long serialVersionUID = -317294700779621212L;
        private int seriesCount;
        private int itemCount;

        public SampleXYZDataset() {
            this(3, 10);
        }

        public SampleXYZDataset(int seriesCount, int itemCount) {
            this.seriesCount = seriesCount;
            this.itemCount = itemCount;
        }

        public int getSeriesCount() {
            return this.seriesCount;
        }

        public String getSeriesName(int series) {
            return "Series " + Integer.toString(series);
        }

        public int getItemCount(int series) {
            return this.itemCount;
        }

        public double getXValue(int series, int item) {
            return 4.0 * ((double)(++item - this.itemCount / 2) / (double)this.itemCount) + Math.sin(series + item);
        }

        public double getYValue(int series, int item) {
            return 20.0 * ((double)(++item) / (double)this.itemCount) + Math.sin(series * 2 + item * 3);
        }

        public double getZValue(int series, int item) {
            return Math.sin(series * 5 + ++item * 7);
        }

        public Comparable getSeriesKey(int series) {
            return "Series " + Integer.toString(series);
        }

        public Number getX(int series, int item) {
            return new Double(this.getXValue(series, item));
        }

        public Number getY(int series, int item) {
            return new Double(this.getYValue(series, item));
        }

        public Number getZ(int series, int item) {
            return new Double(this.getZValue(series, item));
        }
    }
}

