/*
 * Decompiled with CFR 0.152.
 */
package dyn;

import don.ContinueAnalysee;
import drawing.Series;
import dyn.Graphe;
import ihm.Gestionnaire;
import ihm.Habilleur;
import java.util.Iterator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.data.xy.VectorSeries;
import org.jfree.experimental.data.xy.VectorSeriesCollection;

public class Vecteur
extends Graphe {
    public Vecteur(Gestionnaire gest, Habilleur hab, String titreGraphe, String titreX, String titreY) {
        super(gest, hab, titreGraphe, titreX, titreY);
    }

    protected JFreeChart createChart(XYDataset dataset) {
        Series s;
        boolean pie = false;
        Iterator ite = this.getDonnee().iterator();
        if (ite.hasNext() && (s = (Series)ite.next()).getDonneeID(0) instanceof ContinueAnalysee) {
            ContinueAnalysee donnee = (ContinueAnalysee)s.getDonneeID(0);
            pie = donnee.isOrthonorme();
        }
        return ChartFactory.createPieVecPlot(this.getTitreGraphe(), this.getTitreX(), this.getTitreY(), dataset, pie, this.getOrientation(), this.m_gestionnaire.isAffLegende(), false, false);
    }

    protected XYDataset construireSeries() {
        this.setCanvas();
        this.m_data = new VectorSeriesCollection();
        for (Series s : this.getDonnee()) {
            String etiq = s.getSemantique();
            VectorSeries vect = new VectorSeries((Comparable)((Object)etiq));
            int i = 0;
            int nb = 0;
            while (i < s.getNbDonneeID()) {
                if (!this.m_gestionnaire.isFantome(s.getDonneeID(i))) {
                    vect.add(0.0, 0.0, s.getDonneeID(i).getCoord(this.m_gestionnaire.getAxeX()), s.getDonneeID(i).getCoord(this.m_gestionnaire.getAxeY()));
                    this.m_canvas.addPoint(s.getDonneeID(i));
                    ++nb;
                }
                ++i;
            }
            if (nb == 0) continue;
            ((VectorSeriesCollection)this.m_data).addSeries(vect);
        }
        return this.m_data;
    }
}

