/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Continue;
import don.Groupe;
import don.Individu;
import don.ModaliteMoyenne;
import don.Nominale;
import don.QualifiableRepresentable;
import exceptions.ExceptionIntegrite;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modalite
extends QualifiableRepresentable {
    private static final long serialVersionUID = -5668398340053544063L;
    private Nominale m_nominale;
    private ModaliteMoyenne m_pere;
    private Vector<Individu> m_individus;
    private HashMap<Continue, Double> m_val_cont;

    public Modalite(Nominale nominale, String annotation, boolean active, Groupe gr, double[] coord, double[] cos2, double[] contrib, int generation) {
        super(annotation, active, gr, coord, cos2, contrib, generation);
        this.m_nominale = nominale;
        this.m_individus = new Vector();
        this.m_val_cont = new HashMap();
    }

    public Modalite(Nominale nominale, String annotation) {
        super(annotation, false, null, null, null, null, 0);
        this.m_nominale = nominale;
        this.m_individus = new Vector();
    }

    public void setNominale(Nominale m_nominale) {
        this.m_nominale = m_nominale;
    }

    public Nominale getNominale() {
        return this.m_nominale;
    }

    public Vector<Individu> getIndividus() {
        return this.m_individus;
    }

    public double getValeur(Continue c) {
        if (this.m_val_cont == null) {
            this.m_val_cont = new HashMap();
        }
        if (this.m_val_cont.get(c) == null) {
            int nb = 0;
            double val = 0.0;
            for (Individu ind : this.m_individus) {
                ++nb;
                val += c.getValeur(ind);
            }
            this.m_val_cont.put(c, val / (double)nb);
        }
        return this.m_val_cont.get(c);
    }

    public void addIndividu(Individu ind) {
        this.m_individus.add(ind);
        if (!ind.getModalites().contains(this)) {
            ind.addModalite(this);
        }
    }

    public int getNbIndividus() {
        return this.m_individus.size();
    }

    public ModaliteMoyenne getPere() {
        return this.m_pere;
    }

    public void setPere(ModaliteMoyenne pere) {
        this.m_pere = pere;
        if (!pere.getBranches().contains(this)) {
            pere.addBranche(this);
        }
        this.setGeneration(pere.getGeneration() + 1);
    }

    @Override
    public void verifierIntegrite() throws ExceptionIntegrite {
        super.verifierIntegrite();
        int i = 0;
        while (i < this.m_individus.size()) {
            Individu ind = this.m_individus.get(i);
            if (ind.getModalite(this.m_nominale) == null) {
                ind.addModalite(this);
                System.out.println("l'individu n'\u00e9tait pas au courant de sa modalit\u00e9");
            } else if (!ind.getModalite(this.m_nominale).equals(this)) {
                if (!ind.getModalite(this.m_nominale).getNominale().equals(this.m_nominale)) {
                    ind.addModalite(this);
                } else {
                    throw new ExceptionIntegrite("incoh\u00e9rence modalit\u00e9 - individu : \nmodalit\u00e9 : " + this.getAnnotation() + "\nl'individu : " + ind.getAnnotation() + "est li\u00e9 \u00e0 " + ind.getModalite(this.getNominale()).getAnnotation() + "(" + ind.getModalite(this.getNominale()).getNominale().getAnnotation() + ") pour la nominale " + this.m_nominale.getAnnotation());
                }
            }
            ind.verifierIntegrite();
            ++i;
        }
    }
}

