% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dymo.R, R/main.R
\docType{package}
\name{dymo}
\alias{dymo}
\alias{dymo-package}
\title{dymo}
\usage{
dymo(
  df,
  seq_len,
  n_windows = 10,
  ci = 0.8,
  smoother = FALSE,
  min_feats = NULL,
  max_feats = NULL,
  dates = NULL,
  error_scale = "naive",
  error_benchmark = "naive",
  seed = 42
)
}
\arguments{
\item{df}{A data frame with time features on columns. You need at least two time features. In case of missing values, automatic missing imputation through kalman filter will be performed.}

\item{seq_len}{Positive integer. Time-step number of the forecasting sequence. Default: NULL (automatic selection between 1 and the square root of full length).}

\item{n_windows}{Positive integer. Number of validation windows to test prediction error. Default: 10.}

\item{ci}{Confidence interval for prediction. Default: 0.8}

\item{smoother}{Logical. Flag to TRUE for loess smoothing. Default: FALSE.}

\item{min_feats}{Positive integer. Minimum number of time features to combine. Default: NULL (set equal to the total number of features)}

\item{max_feats}{Positive integer. Maximum number of time features to combine. Default: NULL (set equal to the total number of features)}

\item{dates}{Date. Vector with dates for time features.}

\item{error_scale}{String. Scale for the scaled error metrics. Two options: "naive" (average of naive one-step absolute error for the historical series) or "deviation" (standard error of the historical series). Default: "naive".}

\item{error_benchmark}{String. Benchmark for the relative error metrics. Two options: "naive" (sequential extension of last value) or "average" (mean value of true sequence). Default: "naive".}

\item{seed}{Positive integer. Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item comb_metrics: error metrics for all possible combination of time features (for each combination, pred_score, me, mae, mse, rmsse, mpe, mape, rmae, rrmse, rame, mase, smse, sce, gmrae, are averaged across features, ranks and validation windows)
\item best_model: best combination resulting from the average prediction score across different ranks and features, including:
\itemize{
\item best_combination: combination of index and rank for the best model
\item testing_errors: testing errors for each time feature averaged across validation windows
\item quant_preds: min, max, q25, q50, q75, quantiles at selected ci, mean, sd, mode, skewness, kurtosis, IQR to range, median range ratio, upside probability and divergence for each point fo predicted sequences
\item plots: standard plot with confidence interval for each time feature
}
\item time_log
}
}
\description{
Dynamic Mode Decomposition for Multivariate Time Feature Prediction
}
\examples{
dymo(time_features[,c(2, 3, 4)], seq_len = 10, dates = time_features$dates)

}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/dymo}
}

}
\author{
\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]


Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
