% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{stats}
\alias{stats}
\alias{stats.dd}
\alias{stats.ddArray}
\alias{stats.ddArraycc}
\title{Display a Tables of Summary Statistics for Distance Distributions}
\usage{
stats(x, ...)

\method{stats}{dd}(x, extent = "full", zrad = 200, ...)

\method{stats}{ddArray}(x, extent = "full", zrad = 200, ...)

\method{stats}{ddArraycc}(x, extent = "full", zrad = 200, ...)
}
\arguments{
\item{x}{list of models (\code{ddArray}) or single model (\code{dd}) to calculate summary statistics for}

\item{...}{ignored}

\item{extent}{distributions within searched area (\code{"win"}) or extended beyond (\code{"full"})}

\item{zrad}{maximum distance that carcasses can lie
(only used when glm parameters not extensible to Inf)}
}
\value{
list (or list of lists if \code{x} is \code{ddArray}) with \code{$model}
 giving the model parameters and \code{$stats} giving the median, and 75th,
 90th, and 95th quantiles of carcass distances and the estimated probability
 a carcass falls within the search area according to each model
}
\description{
Calculate summary statistics for a single distance distribution 
(\code{\link[=ddFit]{dd}} object), an array of distance distributions all fit to the
same data set (\code{\link[=ddFit]{ddArray}}), or a list of arrays of distance 
distributions fit for different carcass classes but the same site layout
(\code{\link[=ddFit]{ddArraycc}}).
}
