% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_project.R
\name{create_project}
\alias{create_project}
\title{Create a new project.}
\usage{
create_project(owner_id, create_project_req)
}
\arguments{
\item{owner_id}{data.world user name of the project owner.}

\item{create_project_req}{Request object of type \code{\link{project_create_request}}.}
}
\value{
Object of type \code{\link{create_project_response}}.
}
\description{
Create a new project.
}
\examples{
request <- dwapi::project_create_request(
  title='testproject', visibility = 'OPEN',
  objective = 'Test project by R-SDK', tags = c('rsdk', 'sdk', 'arr'),
  license = 'Public Domain')

request <- dwapi::add_file(request = request, name = 'file4.csv',
  url = 'https://data.world/file4.csv')

\dontrun{
dwapi::create_project(create_project_req = request,
  owner_id = 'user')
}
}
