% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dataset.R
\name{create_dataset}
\alias{create_dataset}
\title{Create a new dataset.}
\usage{
create_dataset(owner_id, create_dataset_req)
}
\arguments{
\item{owner_id}{data.world user name of the dataset owner.}

\item{create_dataset_req}{Request object of type \code{\link{dataset_create_request}}.}
}
\value{
Object of type \code{\link{create_dataset_response}}.
}
\description{
Create a new dataset.
}
\examples{
request <- dwapi::dataset_create_request(
  title='testdataset', visibility = 'OPEN',
  description = 'Test Dataset by R-SDK', tags = c('rsdk', 'sdk', 'arr'),
  license_string = 'Public Domain')

request <- dwapi::add_file(request = request, name = 'file4.csv',
  url = 'https://data.world/file4.csv')

\dontrun{
dwapi::create_dataset(create_dataset_req = request,
  owner_id = 'user')
}
}
