% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_project.R
\name{replace_project}
\alias{replace_project}
\title{Create a new project with a specific ID, replacing a project with that ID
if it exists.}
\usage{
replace_project(owner_id, project_id, replace_project_req)
}
\arguments{
\item{owner_id}{data.world user name of the project owner.}

\item{project_id}{identifier to use for the new project, or identifier of
existing project to replace with the newly created project.}

\item{replace_project_req}{Request object of type \code{\link{project_replace_request}}.}
}
\value{
Object of type \code{\link{success_message}}.
}
\description{
Create a new project with a specific ID, replacing a project with that ID
if it exists.
}
\examples{
request <- dwapi::project_replace_request(
  title='testproject', visibility = 'OPEN',
  objective = 'Test project by R-SDK', tags = c('rsdk', 'sdk', 'arr'),
  license = 'Public Domain')

request <- dwapi::add_file(request = request, name = 'file4.csv',
  url = 'https://data.world/file4.csv')

\dontrun{
dwapi::replace_project(create_project_req = request,
  owner_id = 'user', project_id = 'projectid')
}
}
