% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_to_stream.R
\name{append_values_to_stream}
\alias{append_values_to_stream}
\title{Append a record, consisting of named parameters, to a stream.}
\usage{
append_values_to_stream(owner_id, dataset_id, stream_id, retry_times = 3,
  retry_quiet = FALSE, ...)
}
\arguments{
\item{owner_id}{User name and unique identifier of the creator of a
dataset or project}

\item{dataset_id}{Dataset unique identifier}

\item{stream_id}{Stream unique identifier as defined by the user the first
time the stream was used. Only lower case letters, numbers and
dashes are allowed.}

\item{retry_times}{the number of times to retry the request}

\item{retry_quiet}{whether to suppress diagnostic messages during retries}

\item{...}{named parameters giving the variables and values in the record
to be streamed}
}
\value{
Server response message.
}
\description{
Append a record, consisting of named parameters, to a stream.
Each value
must be an atomic vector of length one.  If the data.world API
returns an HTTP status of 429 (Too Many Requests), this function uses
\code{\link[httr]{RETRY}} to retry the request.
}
\examples{
\dontrun{
  dwapi::append_values_to_stream(owner_id = 'user',
    dataset_id = 'dataset', stream_id = 'mystream',
    ID=1, Value='One')
}
}
