% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{min_n}
\alias{min_n}
\title{Minimum of Numeric Values}
\usage{
min_n(x)
}
\arguments{
\item{x}{Numeric vector.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function tends to run faster than 
\code{\link[base]{min}} for large numeric vectors/matrices.
}
\examples{
# For large objects, min_n is faster than min
x <- rnorm(100000)
min(x) == min_n(x)
benchmark(min(x), min_n(x), replications = 1000)

# For smaller objects, min_n is slower than min
x <- rnorm(100)
min(x) == min_n(x)
benchmark(min(x), min_n(x), replications = 20000)

}
