% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{max_n}
\alias{max_n}
\title{Maximum of Numeric Values}
\usage{
max_n(x)
}
\arguments{
\item{x}{Numeric vector.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function tends to run faster than 
\code{\link[base]{max}} for large numeric vectors/matrices.
}
\examples{
# For large objects, max_n is faster than max
x <- rnorm(100000)
max(x) == max_n(x)
benchmark(max(x), max_n(x), replications = 1000)

# For smaller objects, max_n is slower than max
x <- rnorm(100)
max(x) == max_n(x)
benchmark(max(x), max_n(x), replications = 1000)

}
