% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabelDVI.R
\name{relabelDVI}
\alias{relabelDVI}
\title{Automatic labelling of a DVI dataset}
\usage{
relabelDVI(
  dvi,
  victimPrefix = NULL,
  familyPrefix = NULL,
  refPrefix = NULL,
  missingPrefix = NULL,
  missingFormat = NULL,
  othersPrefix = NULL
)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}

\item{victimPrefix}{Prefix used to label PM individuals.}

\item{familyPrefix}{Prefix used to label the AM families.}

\item{refPrefix}{Prefix used to label the reference individuals, i.e., the
typed members of the AM families.}

\item{missingPrefix}{Prefix used to label the missing persons. At most one of
\code{missingPrefix} and \code{missingFormat} can be given.}

\item{missingFormat}{A string indicating family-wise labelling of missing
persons, using \verb{[FAM]}, \verb{[IDX]}, \verb{[MIS]} as place holders with the
following meanings (see Examples):
\itemize{
\item \verb{[FAM]}: family index
\item \verb{[IDX]}: index of missing person within the family
\item \verb{[MIS]}: index within all missing persons
}}

\item{othersPrefix}{Prefix used to label other untyped individuals. Use ""
for numeric labels ( 1, 2, ...).}
}
\value{
A \code{\link[=dviData]{dviData()}} object.
}
\description{
Relabel the individuals and families in a DVI dataset.
}
\examples{

# Builtin dataset `example2`
relabelDVI(example2,
           victimPrefix  = "vic",
           familyPrefix  = "fam",
           refPrefix     = "ref",
           missingPrefix = "mp")

# Family-wise labelling of missing persons
relabelDVI(example2, missingFormat = "M[FAM]-[IDX]")
relabelDVI(example2, missingFormat = "M[IDX] (F[FAM])")
relabelDVI(example2, missingFormat = "fam[FAM].m[IDX]")

}
