% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequentialDVI.R
\name{sequentialDVI}
\alias{sequentialDVI}
\title{Sequential DVI search}
\usage{
sequentialDVI(
  dvi,
  updateLR = TRUE,
  threshold = 1,
  check = TRUE,
  verbose = TRUE,
  debug = FALSE
)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}

\item{updateLR}{A logical. If TRUE, the LR matrix is updated in each
iteration.}

\item{threshold}{A non-negative number. If no pairwise LR values exceed this,
the iteration stops.}

\item{check}{A logical, indicating if the input data should be checked for
consistency.}

\item{verbose}{A logical.}

\item{debug}{A logical. If TRUE, the LR matrix is printed.}
}
\value{
A list with two elements:
\itemize{
\item \code{matches}: A single assignment vector, or (if multiple branches)
a data frame where each row is an assignment vector.
\item \code{details}: A data frame (or a list of data frames, if multiple branches)
including the LR of each identification in the order they were made.
}
}
\description{
Performs a sequential matching procedure based on the pairwise LR matrix. In
each step the pairing corresponding to the highest LR is selected and
included as a match if the LR exceeds the given threshold. By default,
(\code{updateLR = TRUE}) the pairwise LRs are recomputed in each step after
including the data from the identified sample.
}
\details{
If, at any point, the highest LR is obtained by more than one pairing, the
process branches off and produces multiple solutions. (See Value.)
}
\examples{
# Without LR updates
sequentialDVI(example1, updateLR = FALSE)

# With LR updates (default). Note two branches!
r = sequentialDVI(example1)

# Plot the two solutions
plotSolution(example1, r$matches, k = 1)
plotSolution(example1, r$matches, k = 2)

# Add `debug = T` to see the LR matrix in each step
sequentialDVI(example1, debug = TRUE)

# The output of can be fed into `jointDVI()`:
jointDVI(example1, assignments = r$matches)

}
