% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergePM.R
\name{directMatch}
\alias{directMatch}
\title{Direct match LR}
\usage{
directMatch(x, y, geno1 = NULL, geno2 = NULL)
}
\arguments{
\item{x, y}{Typed singletons.}

\item{geno1, geno2}{(Optional) Named character vectors with genotypes for \code{x}
and \code{y} respectively.}
}
\value{
A nonnegative likelihood ratio.
}
\description{
Computes the likelihood ratio comparing if two samples are from the same
individual or from unrelated individuals.
}
\examples{
library(forrel)

x = singleton("a") |> profileSim(markers = NorwegianFrequencies[1:4])
y = relabel(x, new = "b")

# Remove one genotype to make the example more interesting
x = setGenotype(x, id = "a", marker = 1, geno = "-/-")

directMatch(x, y)

}
\seealso{
\code{\link[=mergePM]{mergePM()}}.
}
