% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequentialDVI.R
\name{sequentialDVI}
\alias{sequentialDVI}
\title{Sequential DVI search}
\usage{
sequentialDVI(
  pm,
  am,
  missing,
  updateLR = TRUE,
  threshold = 1,
  check = TRUE,
  verbose = TRUE,
  debug = FALSE
)
}
\arguments{
\item{pm}{PM data: List of singletons.}

\item{am}{AM data: A ped object or list of such.}

\item{missing}{Character vector with names of the missing persons.}

\item{updateLR}{A logical. If TRUE, the LR matrix is updated in each
iteration.}

\item{threshold}{A non-negative number. If no pairwise LR values exceed this,
the iteration stops.}

\item{check}{A logical, indicating if the input data should be checked for
consistency.}

\item{verbose}{A logical.}

\item{debug}{A logical. If TRUE, the LR matrix is printed}
}
\value{
A solution to the DVI problem in the form of an assignment vector.
}
\description{
Sequential DVI search
}
\examples{
pm = example1$pm
am = example1$am
missing = example1$missing

sequentialDVI(pm, am, missing, updateLR = FALSE)
sequentialDVI(pm, am, missing, updateLR = TRUE)

# The output of can be fed into `jointDVI()`:
res = sequentialDVI(pm, am, missing, updateLR = TRUE)
jointDVI(pm, am, missing, assignments = res)

}
