% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncomb.R
\name{ncomb}
\alias{ncomb}
\title{The number of assignments for DVI problem}
\usage{
ncomb(nVfemales, nMPfemales, nVmales, nMPmales)
}
\arguments{
\item{nVfemales}{Integer. The number of female victims.}

\item{nMPfemales}{Integer. The number of female missing persons.}

\item{nVmales}{Integer. The number of male victims.}

\item{nMPmales}{Integer. The number of male missing persons.}
}
\value{
The total number of possible assignments.
}
\description{
The number of victims and missing persons of each sex is given. The number of
possible assignments, i.e., the number of ways the victims can be identified
with the missing persons, is calculated.
}
\examples{

# Example: 3 male victims; 2 male missing persons.
# The number of a priori possible assignments is
m1 = ncomb(0,0,3,2) # 13


# Compare with the complete list of assignments
m2 = expand.grid.nodup(list(V1 = c("*", "M1", "M2"),
                            V2 = c("*", "M1", "M2"),
                            V3 = c("*", "M1", "M2")))
stopifnot(m1 == nrow(m2))

}
