% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{icmp}
\alias{icmp}
\title{Data. DVI example with large reference pedigree}
\format{
A list of 3 elements:
\itemize{
\item \code{pm}: A list of 5 singletons (victims).
\item \code{am}: A reference pedigree with 6 genotyped members and 12 missing persons.
\item \code{missing}: A vector containing the names of the missing persons.
}
}
\usage{
icmp
}
\description{
DVI dataset based loosely on the ICMP workshop material
http://www.few.vu.nl/~ksn560/Block-III-PartI-KS-ISFG2017.pdf (page 18).
There are 3 female victims, 2 male victims and 6 missing persons of both sexes.
We have renamed the individuals and simulated data for 13 CODIS markers.
}
\examples{

\donttest{
pm = icmp$pm
am = icmp$am
missing = icmp$missing

plot(am, hatched = typedMembers)
# jointDVI(pm, am, missing)
}   
}
\keyword{datasets}
