% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_by_group.R
\name{cut_by_group}
\alias{cut_by_group}
\title{Cutting data by group}
\usage{
cut_by_group(df, col_data, col_group, group, cat_col)
}
\arguments{
\item{df}{(\code{dataframe}) with a column of data to be cut and a column specifying the group of each observation.}

\item{col_data}{(\code{character}) the column containing the data to be cut.}

\item{col_group}{(\code{character}) the column containing the names of the groups according to which the data should be
split.}

\item{group}{(\verb{nested list}) providing for each parameter value that should be analyzed in a categorical way: the
name of the parameter (\code{character}), a series of breakpoints (\code{numeric}) where the first breakpoints is typically
\code{-Inf} and the last \code{Inf}, and a series of name which will describe each category (\code{character}).}

\item{cat_col}{(\code{character}) the name of the new column in which the cut label should he stored.}
}
\value{
\code{data.frame} with a column containing categorical values.
}
\description{
Cutting data by group
}
\details{
Function used to categorize numeric data stored in long format depending on their group. Intervals are
closed on the right (and open on the left).
}
\examples{
group <- list(
  list(
    "Height",
    c(-Inf, 150, 170, Inf),
    c("=<150", "150-170", ">170")
  ),
  list(
    "Weight",
    c(-Inf, 65, Inf),
    c("=<65", ">65")
  ),
  list(
    "Age",
    c(-Inf, 31, Inf),
    c("=<31", ">31")
  ),
  list(
    "PreCondition",
    c(-Inf, 1, Inf),
    c("=<1", "<1")
  )
)
data <- data.frame(
  SUBJECT = rep(letters[1:10], 4),
  PARAM = rep(c("Height", "Weight", "Age", "other"), each = 10),
  AVAL = c(rnorm(10, 165, 15), rnorm(10, 65, 5), runif(10, 18, 65), rnorm(10, 0, 1)),
  index = 1:40
)

cut_by_group(data, "AVAL", "PARAM", group, "my_new_categories")
}
