% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull-rd.R, R/pull.R
\name{pull.duckplyr_df}
\alias{pull.duckplyr_df}
\title{Extract a single column}
\usage{
\method{pull}{duckplyr_df}(.data, var = -1, name = NULL, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{var}{A variable specified as:
\itemize{
\item a literal variable name
\item a positive integer, giving the position counting from the left
\item a negative integer, giving the position counting from the right.
}

The default returns the last column (on the assumption that's the
column you've created most recently).

This argument is taken by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names and column locations).}

\item{name}{An optional parameter that specifies the column to be used
as names for a named vector. Specified in a similar manner as \code{var}.}

\item{...}{For use by methods.}
}
\description{
This is a method for the \code{\link[dplyr:pull]{dplyr::pull()}} generic.
See "Fallbacks" section for differences in implementation.
\code{pull()} is similar to \code{$}.
It's mostly useful because it looks a little nicer in pipes,
it also works with remote data frames, and it can optionally name the output.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{pull.duckplyr_df()}
\itemize{
\item with a selection that returns no columns.
}

These features fall back to \code{\link[dplyr:pull]{dplyr::pull()}}, see \code{vignette("fallback")} for details.
}

\examples{
library(duckplyr)
pull(mtcars, cyl)
pull(mtcars, 1)
}
\seealso{
\code{\link[dplyr:pull]{dplyr::pull()}}
}
