% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLUSTERING-repeat-clustering.R
\name{repeat_clustering}
\alias{repeat_clustering}
\title{Repeat a clustering configuration}
\usage{
repeat_clustering(series, clusterings, config_id, ...)
}
\arguments{
\item{series}{The same time series that were given to \code{\link[=compare_clusterings]{compare_clusterings()}}.}

\item{clusterings}{The list returned by \code{\link[=compare_clusterings]{compare_clusterings()}}.}

\item{config_id}{The character indicating which configuration should be re-computed. Obtained
from the \code{clusterings}' \code{results}' data frames.}

\item{...}{More arguments for \code{\link[=tsclust]{tsclust()}} (e.g. \code{trace}).}
}
\value{
A \linkS4class{TSClusters} object.
}
\description{
Repeat a clustering made with \code{\link[=compare_clusterings]{compare_clusterings()}} in order to obtain the \linkS4class{TSClusters}
object.
}
\details{
Since the purpose of \code{\link[=compare_clusterings]{compare_clusterings()}} is to test many configurations, it is desirable to
set its \code{return.objects} parameter to \code{FALSE} in order to save RAM. This function can then be
used to compute the clustering object for a specific \code{config_id}.
}
\section{Limitations}{


If the preprocessing function is subject to randomness, the clustering will not be correctly
re-created by this function, since \code{\link[=compare_clusterings]{compare_clusterings()}} applies all preprocessing before
calling \code{\link[=tsclust]{tsclust()}}.

If any parameters were given to \code{\link[=compare_clusterings]{compare_clusterings()}} through its ellipsis, they should
probably be given to this function too.
}

