% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLUSTERING-tadole.R
\name{TADPole}
\alias{TADPole}
\alias{tadpole}
\title{TADPole clustering}
\usage{
TADPole(data, k = 2L, dc, window.size, error.check = TRUE, lb = "lbk",
  trace = FALSE)

tadpole(data, k = 2L, dc, window.size, error.check = TRUE, lb = "lbk",
  trace = FALSE)
}
\arguments{
\item{data}{A matrix or data frame where each row is a time series, or a list where each element
is a time series. Multivariate series are \strong{not} supported.}

\item{k}{The number of desired clusters. Can be a vector with several values.}

\item{dc}{The cutoff distance(s). Can be a vector with several values.}

\item{window.size}{Window size constraint for DTW (Sakoe-Chiba). See details.}

\item{error.check}{Logical indicating whether the function should try to detect inconsistencies
and give more informative errors messages. Also used internally to avoid repeating checks.}

\item{lb}{Which lower bound to use, "lbk" for \code{\link[=lb_keogh]{lb_keogh()}} or "lbi" for \code{\link[=lb_improved]{lb_improved()}}.}

\item{trace}{Logical flag. If \code{TRUE}, more output regarding the progress is printed to screen.}
}
\value{
A list with:
\itemize{
\item \code{cl}: Cluster indices.
\item \code{centroids}: Indices of the centroids.
\item \code{distCalcPercentage}: Percentage of distance calculations that were actually performed.
}

For multiple \code{k}/\code{dc} values, a list of lists is returned, each internal list having the
aforementioned elements.
}
\description{
Time-series Anytime Density Peaks Clustering as proposed by Begum et al. (2015).
}
\details{
This function can be called either directly or through \code{\link[=tsclust]{tsclust()}}.

TADPole clustering adopts a relatively new clustering framework and adapts it to time series
clustering with DTW. See the cited article for the details of the algorithm.

Because of the way the algorithm works, it can be considered a kind of Partitioning Around
Medoids (PAM). This means that the cluster centroids are always elements of the data. However,
this algorithm is deterministic, depending on the value of \code{dc}.

The algorithm first uses the DTW's upper and lower bounds (Euclidean and LB_Keogh respectively)
to find series with many close neighbors (in DTW space). Anything below the cutoff distance
(\code{dc}) is considered a neighbor. Aided with this information, the algorithm then tries to prune
as many DTW calculations as possible in order to accelerate the clustering procedure. The series
that lie in dense areas (i.e. that have lots of neighbors) are taken as cluster centroids.

The algorithm relies on the DTW bounds, which are only defined for univariate time series of
equal length.

Parallelization is supported, but it will only be used if multiple \code{dc} values are specified in
the same call.

The windowing constraint uses a centered window. The calculations expect a value in
\code{window.size} that represents the distance between the point considered and one of the edges
of the window. Therefore, if, for example, \code{window.size = 10}, the warping for an
observation \eqn{x_i} considers the points between \eqn{x_{i-10}} and \eqn{x_{i+10}}, resulting
in \code{10(2) + 1 = 21} observations falling within the window.
}
\section{Parallel Computing}{


  Please note that running tasks in parallel does \strong{not} guarantee faster computations. The
  overhead introduced is sometimes too large, and it's better to run tasks sequentially.

  This function uses the \code{\link[RcppParallel:RcppParallel-package]{RcppParallel}} package
  for parallelization. It uses all available threads by default (see
  \code{\link[RcppParallel:defaultNumThreads]{RcppParallel::defaultNumThreads()}}), but this can
  be changed by the user with
  \code{\link[RcppParallel:setThreadOptions]{RcppParallel::setThreadOptions()}}.

  An exception to the above is when this function is called within a
  \code{\link[foreach:foreach]{foreach}} parallel loop \strong{made by dtwclust}. If the parallel
  workers do not have the number of threads explicitly specified, this function will default to 1
  thread per worker. See the parallelization vignette for more information
  (\code{browseVignettes("dtwclust")}).



This function also takes advantage of multi-processing with a parallel backend (e.g. when using
the \pkg{doParallel} package), but only for multiple values of \code{dc}.
}

\references{
Begum N, Ulanova L, Wang J and Keogh E (2015). ``Accelerating Dynamic Time Warping Clustering
with a Novel Admissible Pruning Strategy.'' In \emph{Conference on Knowledge Discovery and Data
Mining}, series KDD '15. ISBN 978-1-4503-3664-2/15/08, \url{
http://dx.doi.org/10.1145/2783258.2783286}.
}
