% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-envelope.R
\name{compute_envelope}
\alias{compute_envelope}
\alias{compute_envelop}
\title{Time series warping envelopes}
\usage{
compute_envelope(x, window.size, error.check = TRUE)

compute_envelop(x, window.size, error.check = TRUE)
}
\arguments{
\item{x}{A univariate time series.}

\item{window.size}{Window size for envelope calculation. See details.}

\item{error.check}{Logical indicating whether the function should try to detect inconsistencies
and give more informative errors messages. Also used internally to avoid repeating checks.}
}
\value{
A list with two elements (lower and upper envelopes respectively): \code{lower} and \code{upper}.
}
\description{
This function computes the envelopes for DTW lower bound calculations with a Sakoe-Chiba band for
a given univariate time series using the streaming algorithm proposed by Lemire (2009).
}
\details{
The windowing constraint uses a centered window. The calculations expect a value in
\code{window.size} that represents the distance between the point considered and one of the edges
of the window. Therefore, if, for example, \code{window.size = 10}, the warping for an
observation \eqn{x_i} considers the points between \eqn{x_{i-10}} and \eqn{x_{i+10}}, resulting
in \code{10(2) + 1 = 21} observations falling within the window.
}
\note{
This envelope is calculated assuming a Sakoe-Chiba constraint for DTW.
}
\examples{

data(uciCT)

H <- compute_envelope(CharTraj[[1L]], 18L)

matplot(do.call(cbind, H), type = "l", col = 2:3)
lines(CharTraj[[1L]])

}
\references{
Lemire D (2009). ``Faster retrieval with a two-pass dynamic-time-warping lower bound .'' \emph{Pattern
Recognition}, \strong{42}(9), pp. 2169 - 2180. ISSN 0031-3203,
\url{http://dx.doi.org/10.1016/j.patcog.2008.11.030},
\url{http://www.sciencedirect.com/science/article/pii/S0031320308004925}.
}
