% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\docType{package}
\name{dtwclust-package}
\alias{dtwclust-package}
\title{Time series clustering along with optimizations for the Dynamic Time Warping distance}
\description{
Time series clustering with a wide variety of strategies and a series of optimizations specific
to the Dynamic Time Warping (DTW) distance and its corresponding lower bounds (LBs). There are
implementations of both traditional clustering algorithms, and more recent procedures such as
k-Shape and TADPole clustering. Functionality can be easily extended with custom distance
measures and centroid definitions.
}
\details{
Many of the algorithms implemented in this package are specifically tailored to DTW, hence its
name. However, the main clustering function is flexible so that one can test many different
clustering approaches, using either the time series directly, or by applying suitable
transformations and then clustering in the resulting space. Other implementations included in the
package provide some alternatives to DTW.

DTW is a dynamic programming algorithm that tries to find the optimum warping path between two
series. Over the years, several variations have appeared in order to make the procedure faster or
more efficient. Please refer to the included references for more information, especially Giorgino
(2009), which is a good practical introduction.

Most optimizations require equal dimensionality, which means time series should have equal
length. DTW itself does not require this, but it is relatively expensive to compute. Other
distance definitions may be used, or series could be reinterpolated to a matching length
(Ratanamahatana and Keogh 2004).

Other packages that are particularly leveraged here are the \pkg{proxy} package for distance
matrix calculations and the \pkg{dtw} package for some of the core DTW calculations.

The main clustering function and entry point for this package is \code{\link[=tsclust]{tsclust()}}, with a convenience
wrapper for multiple tests in \code{\link[=compare_clusterings]{compare_clusterings()}}.

Please note the random number generator is set to L'Ecuyer-CMRG when \pkg{dtwclust} is attached
in an attempt to preserve reproducibility. You are free to change this afterwards if you wish.
See \code{\link[base:RNGkind]{base::RNGkind()}}.

For more information, please read the included package vignette, which can be accessed by typing
\code{vignette("dtwclust")}.
}
\note{
The \pkg{methods} \link[methods:methods-package]{package} must be attached in order for some internal
functions to work properly. This is usually done automatically by \code{R}, with \code{\link[utils:Rscript]{utils::Rscript()}}
being an exception. As of \pkg{dtwclust} version 3.2.0, attaching the \pkg{methods} package is
also done when attaching \pkg{dtwclust} (via \code{\link[base:library]{base::library()}}), so please always attach the
package before using its functionality.

This software package was developed independently of any organization or institution that is or
has been associated with the author.
}
\references{
Please refer to the package vignette references.
}
\seealso{
\code{\link[=tsclust]{tsclust()}}, \code{\link[=compare_clusterings]{compare_clusterings()}}, \code{\link[proxy:dist]{proxy::dist()}}, \code{\link[dtw:dtw]{dtw::dtw()}}
}
\author{
Alexis Sarda-Espinosa
}
