% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{subset,twdtwTimeSeries-method}
\alias{subset-twdtwTimeSeries}
\alias{subset,twdtwMatches-method}
\alias{subset-twdtwMatches}
\alias{subset,twdtwRaster-method}
\alias{subset-twdtwRaster}
\title{Subset time series}
\usage{
\S4method{subset}{twdtwTimeSeries}(x, labels = NULL)

\S4method{subset}{twdtwMatches}(x, timeseries.labels = NULL,
  patterns.labels = NULL, k = NULL)

\S4method{subset}{twdtwRaster}(x, e = NULL, layers = NULL)
}
\arguments{
\item{x}{An objects of class twdtw*.}

\item{labels}{A character vector with time series labels.}

\item{timeseries.labels}{a vector with labels of the time series.}

\item{patterns.labels}{a vector with labels of the patterns.}

\item{k}{A positive integer. The index of the last alignment to include in 
the subset.}

\item{e}{An extent object, or any object from which an Extent object can
be extracted. See \link[raster]{crop} for details.}

\item{layers}{A vector with the names of the \code{twdtwRaster} object to include in 
the subset.}
}
\value{
An object of class twdtw*.
}
\description{
Get subsets from objects of class twdtw*.
}
\examples{
# Getting time series from objects of class twdtwTimeSeries
ts = twdtwTimeSeries(MOD13Q1.ts.list)
ts = subset(ts, 2)
ts
# Getting time series from objects of class twdtwTimeSeries
patt = twdtwTimeSeries(MOD13Q1.patterns.list)
mat = twdtwApply(x=ts, y=patt, weight.fun=logisticWeight(-0.1,100))
mat = subset(mat, k=4)

## This example creates a twdtwRaster object and extracts time series from it. 

# Creating objects of class twdtwRaster with evi and ndvi time series 
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
ndvi = brick(system.file("lucc_MT/data/ndvi.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
rts = twdtwRaster(evi, ndvi, timeline=timeline)

rts_evi = subset(rts, layers="evi")

field_samples = read.csv(system.file("lucc_MT/data/samples.csv", package="dtwSat"))
prj_string = scan(system.file("lucc_MT/data/samples_projection", package="dtwSat"), 
                  what = "character")

# Extract time series 
ts_evi = getTimeSeries(rts_evi, y = field_samples, proj4string = prj_string)

# Subset all labels = "Forest"
ts_forest = subset(ts_evi, labels="Forest")

}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwRaster-class}}, 
\code{\link[dtwSat]{twdtwTimeSeries-class}}, and 
\code{\link[dtwSat]{twdtwMatches-class}}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
