% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopping_delegates.R
\name{stop_for_sample_size}
\alias{stop_for_sample_size}
\title{Stopping for sample size reached}
\usage{
stop_for_sample_size(x, max_sample_size)
}
\arguments{
\item{x}{An object of class 'mtd'.}

\item{max_sample_size}{An integer; specifying the maxmium number of subjects
to be recruited.}
}
\description{
This is a function for use with applied_crm for the stop_func
    argument. The rule will suggest stopping in the scenario that a maximum
    number of subjects has been recruited.
}
\details{
This function is an example of a possible stopping function to be
    used with applied_crm, it will modifiy the 'mtd' class object produced by
    applied_crm to include a logical value under the name 'stop' indicting
    whether or not the trial should stop. The package dtpcrm contains a few
    of these functions for possible use with applied_crm.
}
\examples{
prior  <- c(0.1, 0.3, 0.5)
target <- 0.2
tox    <- c(0, 0, 1, 0, 1, 1)
level  <- c(1, 1, 1, 2, 2, 2)

stop_rule <- function(x){
  x <- stop_for_sample_size(x, max_sample_size = 20)
}

crm <- applied_crm(prior, target, tox, level, no_skip_esc = TRUE, no_skip_deesc = TRUE,
                   global_coherent_esc = TRUE, stop_func = stop_rule)

}
\keyword{CRM}
\keyword{dtpcrm}
\keyword{stop}
