% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{encode}
\alias{encode}
\alias{aplEncode}
\title{Convert a value to its representation in another chosen base}
\usage{
encode(base, ind)
}
\arguments{
\item{base}{A numeric vector which describes the number system in which we want to recode the data.}

\item{ind}{The value to convert represented by a number or a numeric vector.}
}
\value{
A vector or a matrix of the data converted.
}
\description{
The \code{aplEncode} function of the project APL in R (\url{https://rpubs.com/deleeuw/158476}) has been adapted to follow the standard implementation of the APL \code{encode} function.
}
\examples{
encode(c(2,2,2,2), 11)  # find the base 2 representation of number 11
encode(c(365,24,60), 2997) # convert 2997 minutes to days-hrs-min.
}
\references{
\itemize{
\item Jan de Leeuw and Masanao Yajima (March 07, 2016) \emph{APL in R (Version 009)}, Source code. \url{https://rpubs.com/deleeuw/158476}
 \item  L. Gilman and A. J. Rose.(1974): \emph{APL an Interactive Approach}, Second Edition, John Wiley, New York.
 \item  APL 68000 Level II language manual. MicroAPL Ltd. 1990.
 }
}
\author{
Claude Boivin
}
