% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nameRows.R
\name{nameRows}
\alias{nameRows}
\title{Combining the column names of a matrix to construct names for the rows}
\usage{
nameRows(tt, f)
}
\arguments{
\item{tt}{A (0,1)-matrix or a boolean matrix.}

\item{f}{Deprecated. Old name for \code{tt} matrix.}
}
\value{
A character vector of labels obtained for the rows of the \code{tt} matrix. The length of the result is \code{nrow(tt)}.
}
\description{
This function determines the name of a row from all the columns of the \code{tt} that show 1 for that row.
}
\details{
The row containing only 1s is called "frame", to avoid too long a label. The empty set is identified by its code "u00f8". The "+" sign is used to represent the logical "or" operator. The space " " is used to represent the logical "and" operator. Note that in the case of a product space defined on many variables, row labels can become very long.
}
\examples{
tt <- matrix(c(0,0,0,1,0,0,0,0,1,1,0,1,1,1,1),ncol = 3, byrow = TRUE)
colnames(tt) <- c("A","B","C")
rownames(tt) <-nameRows(tt)
tt
}
\author{
Claude Boivin, Stat.ASSQ
}
