% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ind2joint}
\alias{ind2joint}
\title{Independent to joint function}
\usage{
ind2joint(f_list, tri_f_list, tri_h_list, deriv_order)
}
\arguments{
\item{f_list}{list of \code{derivs} objects of length \eqn{M}, e.g. \eqn{list(f_1(\cdot), f_2(\cdot),...,f_M(\cdot))}}

\item{tri_f_list}{list of length \eqn{K} trind_generator objects, the \eqn{kth} element corresponds to \eqn{kth} derivs object.}

\item{tri_h_list}{list of length \eqn{K} trind_generator objects, the \eqn{kth} element corresponds to a derivs object with \eqn{k \cdot (k+1)/2} parameters.}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}
}
\value{
Returns a derivs object.
}
\description{
Combines multiple derivs objects into a single derivs object.
}
\details{
Let \eqn{f_m} be a function defined in [trind()], where \eqn{m \in {1,...,M}}.
Define \eqn{h((x_{n1},x_{n2},...,x_{nK})) = (f_1(x_{n1}), f_2(x_{n2}), ... ,f_M(x_{nK}))}.
In order to get the derivatives of \eqn{h(\cdot)} w.r.t all parameters \eqn{x_{nk}}, the independent functions are combined.
For more details see [trind()] and [trind_generator()].
}
\examples{
A<-matrix(c(1:9)/10, ncol=1)
A_derivs<-list2derivs(list(A, A^0, A^2, A^3, A^4), deriv_order=4)
B_derivs<-transform(A, type="exp", par=0, deriv_order=4)
ind2joint (list(A_derivs,B_derivs),
           list(trind_generator(1),trind_generator(1)),
           list(trind_generator(1),trind_generator(1+1)), 4)

}
\seealso{
Other derivs: 
\code{\link{chainrule}()},
\code{\link{derivs_transform}()},
\code{\link{differencerule}()},
\code{\link{list2derivs}()},
\code{\link{productrule}()},
\code{\link{quotientrule}()},
\code{\link{sumrule}()},
\code{\link{trind_generator}()},
\code{\link{trind}()}
}
\concept{derivs}
