% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgcv_cop.R
\name{cop}
\alias{cop}
\title{cop}
\usage{
cop(link = list("glogit"), W, distr_cop = "normal", rot = 0)
}
\arguments{
\item{link}{formula, specifying the link for \eqn{\delta} parameter. See details.}

\item{W}{numeric matrix of pseudo observations. Must have two columns.}

\item{distr_cop}{string, defines the copula family:\cr
\code{independent} = Independence copula \cr
\code{normal} = Gaussian copula \cr
\code{clayton} = Clayton copula \cr
\code{gumbel} = Gumbel copula \cr
\code{frank} = Frank copula \cr
\code{joe} = Joe copula \cr
\code{amh} = Ali-Mikhail-Haq copula \cr}

\item{rot}{integer determining the rotation for Archimedian copulas. Can be \code{90}, \code{180} or \code{270}.}
}
\value{
An object inheriting from class \code{general.family} of the mgcv package, which can be used in the 'mgcv' and 'dsfa' package.
}
\description{
The cop implements multiple copula distributions in which the parameter \eqn{\delta} can depend on additive predictors.
Useable with \code{mgcv::gam}, the additive predictors are specified via a formula.
}
\details{
Mostly internal function. Used with gam to fit copula model, which in turn is used for starting values. The function \code{gam} is from the mgcv package and is called with a formula.
The formula specifies a dummy on the left hand side and the structure of the additive predictor for the \eqn{\delta} parameter on the right hand side.
Link function is "generalized logit", where for each \code{distr_cop} argument there are specific \code{min} and \code{max} arguments, which are the boundaries of the parameter space.
Although the parameter space is larger in theory for some copulas, numeric under- and overflow limits the parameter space. The intervals for the parameter \code{delta} are provided by \code{\link[=delta_bounds]{delta_bounds()}}.
WARNING: Only the estimates of the coefficients are useful. The rest of the 'mgcv' object has no meaningful values,
as \code{\link[mgcv:gam]{gam()}} was more or less abused here.
}
\examples{
#Set seed, sample size and type of copula
set.seed(1337)
N=500 #Sample size
cop="gumbel" #copula
rot=180 #rotation

#Generate covariates
x1<-runif(N,-1,1); x2<-runif(N,-1,1)

#Set parameters of the copula
eta<-matrix(1+2.5*x1+1.75*sin(pi*x2),nrow=N)
delta<-transform(x=eta, type="glogitinv", par=as.numeric(delta_bounds(cop)), deriv_order = 0)

#Simulate pseudo observations W and create dataset
dat<-as.data.frame(rcop(n=N, delta=delta, distr_cop=cop, rot=rot))
dat$y<-1 #Add dummy response variable

#Write formulae for parameters
delta_formula<-y~x1+s(x2,bs="ps")

#Fit model
model<-mgcv::gam(delta_formula, data=dat,
                 family=cop(W=dat[,1:2],
                            distr_cop=cop, rot=rot),
                 optimizer="efs")

#Smooth effects
#Effect of x2 on the predictor of delta
plot(model, select=1) #Estimated function
lines(x2[order(x2)], 1.75*sin(pi*x2[order(x2)])-
        mean(1.75*sin(pi*x2)), col=2) #True effect

}
\references{
\itemize{
\item \insertRef{schmidt2022mvdsfm}{dsfa}
\item \insertRef{wood2017generalized}{dsfa}
\item \insertRef{aigner1977formulation}{dsfa}
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{azzalini2013skew}{dsfa}
\item \insertRef{schmidt2020analytic}{dsfa}
}
}
\seealso{
Other copula: 
\code{\link{dcop}()},
\code{\link{delta_bounds}()}
}
\concept{copula}
