\name{eval.estimation}
\alias{eval.estimation}
\alias{eval.estimation.set}
\alias{is.estimation.evaluation}

\title{Evaluate an estimation method}
\description{Evaluate an estimation method.}
\usage{
    eval.estimation(model, replications=100, rng=NULL, quiet=F, 
                       simulation.args=NULL,
                       estimation=NULL, estimation.args=NULL, 
                       criterion ="parms", criterion.args =NULL, spawn=.SPAWN)
    is.estimation.evaluation(obj)
}
\arguments{
    \item{model}{A TSmodel.} 
    \item{replications}{The number of simulations.}
    \item{rng}{The RNG and starting seed.}
    \item{quiet}{If T then no information is printed during estimation.}
    \item{simulation.args}{A list of any arguments to pass to simulate.}
    \item{estimation}{A character string indicating the estimation routine to use.}
    \item{estimation.args}{A list of any arguments to pass to the estimation routine.}
    \item{criterion}{
    A function to apply to the results of estimation to extract 
    the information which is to be retained.}
    \item{criterion.args}{
    A list of any arguments to be passed to the criterion function.}
}
\value{
A list with element \code{result} of length replications, each element containing the
results of criterion(estimation(simulate(model))). Other elements of
the list contain information from the supplied arguments.
}
\details{
estimation.args and criterion.args should be NULL if no args are needed.
If model is an object of class 'estimation.evaluation' or 'simulation'
then the model and the seed!!! are extracted so the evaluation will be
based on the same generated sample.
criterion can be { 'parms', 'roots', 'TSmodel', 'TSestModel'}
With the default (parms) or with TSmodel the other criteria can be reconstructed
(when the estimation method finds a known form for the model - which
is not always the case, for example with est.black.box methods).
If criterion = 'roots' then criterion.args= list(verbose=F) is advised.
}
\seealso{
\code{\link{simulate}}
\code{\link{monte.carlo.simulations}}
\code{\link{distribution}}
\code{\link{forecast.cov.wrt.true}}
}
\examples{
    if(is.R()) data("eg1.DSE.data.diff", package="dse1")
    model <- est.VARX.ls(TSdata(output=output.data(eg1.DSE.data.diff)))
    z <-  eval.estimation(model, 
       estimation="est.VARX.ls", estimation.args=list(max.lag=2))
    zz <-  eval.estimation(model, 
       estimation="est.VARX.ls", estimation.args=list(max.lag=2),
       simulation.args=list(sampleT=50, sd=1.5))
    is.estimation.evaluation(z)
}

%\keyword{DSE}
\keyword{ts}

