% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expmodel.r
\name{expmodel}
\alias{expmodel}
\title{Constructor for S3 class \code{expmodel}}
\usage{
expmodel(data = data, freq = NULL, stepsize = c(0.5, 0.3))
}
\arguments{
\item{data}{A nonnegative numeric vector of a data set to be estimated.}

\item{freq}{A frequency vector corresponding to the \code{data} vector.
The default value is \code{NULL}, which means all frequencies are one.
If supplied, the length of a vector should be same as \code{data} and
each element should be a nonnegative integer.}

\item{stepsize}{A numeric vector whose element is larger than 0 and smaller
than 1, and decreasing order. The default value is \code{c(0.5, 0.3)}.
If you encounter numerical difficulties, decreasing its values, for
example, to \code{c(0.4, 0.2)}, might help to estimate a model.}
}
\value{
An object of Exponential-based model \code{expmodel}.
}
\description{
This function is a constructor for S3 class \code{expmodel},
which represents Exponential-based model.
It usually takes \code{data} and optionally \code{freq} as arguments and
also optionally \code{stepsize}
Members of interest in practice are \code{result} and \code{coeffs}, which maintain
the information of estimates and coefficients of polynomials, respectively.
}
\examples{
## Create `expmodel` object from a data set `mixexpgamma$n200`.
 emodel <- expmodel(mixexpgamma$n200)
## Create `expmodel` object from a data set `mixExpGammaHist$n800p` and
## its frequencies `mixExpGammaHist$n800f`.
 emodel <- expmodel(mixExpGammaHist$n800p, mixExpGammaHist$n800f)
}
\seealso{
\code{\link[=summary.expmodel]{summary.expmodel()}} \code{\link[=plot.expmodel]{plot.expmodel()}} \code{\link[=estimate.expmodel]{estimate.expmodel()}}
}
