% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculate_posterior}
\alias{calculate_posterior}
\title{Calculate posterior of ability}
\usage{
calculate_posterior(scores, tau, qp, mu, sd)
}
\arguments{
\item{scores}{A vector with PASS/FAIL observations.
Scores are coded numerically as \code{pass = 1} and \code{fail = 0}.}

\item{tau}{A vector containing the item difficulties for the item
scores in \code{scores} estimated from the Rasch model in the
preferred metric/scale.}

\item{qp}{Numeric vector of equally spaced quadrature points.}

\item{mu}{Numeric scalar. The mean of the prior.}

\item{sd}{Numeric scalar. Standard deviation of the prior.}
}
\value{
A \code{list} with three elements:\tabular{ll}{
   Name \tab Label \cr
   \code{eap} \tab Mean of the posterior \cr
   \code{gp} \tab Vcetor of quadrature points \cr
   \code{posterior} \tab Vector with posterior distribution. \cr
}


Since \verb{dscore V40.1} the function does not return the \code{"start"} element.
}
\description{
Calculate posterior of ability
}
\author{
Stef van Buuren, Arjan Huizing, 2020
}
