% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.as_tibble.R
\name{ds.as_tibble}
\alias{ds.as_tibble}
\title{Coerce a data frame or matrix to a tibble.}
\usage{
ds.as_tibble(
  x = NULL,
  .rows = NULL,
  .name_repair = "check_unique",
  rownames = NULL,
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{x}{A data frame or matrix.}

\item{.rows}{The number of rows, useful to create a 0-column tibble or just as an additional
check.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
  \item "minimal": No name repair or checks, beyond basic existence.
  \item "unique": Make sure names are unique and not empty.
  \item "check_unique": (default value), no name repair, but check they are unique.
  \item "universal": Make the names unique and syntactic.
}}

\item{rownames}{How to treat existing row names of a data frame or matrix:
\itemize{
  \item `NULL`: remove row names. This is the default.
  \item `NA`: keep row names.
  \item A string: the name of a new column. Existing rownames are transferred
  into this column and the \code{row.names} attribute is deleted.
  No name repair is applied to the new column name, even if `x` already contains
  a column of that name.
}}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{DataSHIELD connections object.}
}
\value{
No return value, called for its side effects. A tibble with the name specified by \code{newobj} is created on the server.
}
\description{
DataSHIELD implementation of \code{tibble::as_tibble}. Currently only implemented
for data frames and tibbles.
}
\examples{
\dontrun{
ds.as_tibble(
  x = "mtcars",
  newobj = "mtcars_tib",
  datasources = conns
)
}
}
