% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fun.R
\name{plot_chars}
\alias{plot_chars}
\title{Plot text characters (from file or user input) and match patterns.}
\usage{
plot_chars(
  x = NA,
  file = "",
  lbl_hi = NA,
  lbl_lo = NA,
  bg_hi = NA,
  bg_lo = "[[:space:]]",
  lbl_rotate = NA,
  case_sense = TRUE,
  lbl_tiles = TRUE,
  angle_fg = c(-90, 90),
  angle_bg = 0,
  col_lbl = "black",
  col_lbl_hi = pal_ds4psy[[1]],
  col_lbl_lo = pal_ds4psy[[9]],
  col_bg = pal_ds4psy[[7]],
  col_bg_hi = pal_ds4psy[[4]],
  col_bg_lo = "white",
  col_sample = FALSE,
  rseed = NA,
  cex = 3,
  fontface = 1,
  family = "sans",
  borders = FALSE,
  border_col = "white",
  border_size = 0.5
)
}
\arguments{
\item{x}{The text to plot (as a character vector). 
Different elements denote different lines of text. 
If \code{x = NA} (as per default), 
the \code{file} argument is used to read 
a text file or user input from the Console.}

\item{file}{A text file to read (or its path). 
If \code{file = ""} (as per default), 
\code{scan} is used to read user input from the Console. 
If a text file is stored in a sub-directory, 
enter its path and name here (without any leading or 
trailing "." or "/").}

\item{lbl_hi}{Labels to highlight (as regex). 
Default: \code{lbl_hi = NA}.}

\item{lbl_lo}{Labels to de-emphasize (as regex). 
Default: \code{lbl_lo = NA}.}

\item{bg_hi}{Background tiles to highlight (as regex). 
Default: \code{bg_hi = NA}.}

\item{bg_lo}{Background tiles to de-emphasize (as regex). 
Default: \code{bg_lo = "[[:space:]]"}.}

\item{lbl_rotate}{Labels to rotate (as regex). 
Default: \code{lbl_rotate = NA}.}

\item{case_sense}{Boolean: Distinguish 
lower- vs. uppercase characters in pattern matches? 
Default: \code{case_sense = TRUE}.}

\item{lbl_tiles}{Add character labels to tiles? 
Default: \code{lbl_tiles = TRUE} (i.e., show labels).}

\item{angle_fg}{Angle(s) for rotating character labels 
matching the pattern of the \code{lbl_rotate} expression. 
Default: \code{angle_fg = c(-90, 90)}. 
If \code{length(angle_fg) > 1}, a random value 
in uniform \code{range(angle_fg)} is used for every character.}

\item{angle_bg}{Angle(s) of rotating character labels 
not matching the pattern of the \code{lbl_rotate} expression. 
Default: \code{angle_bg = 0} (i.e., no rotation). 
If \code{length(angle_bg) > 1}, a random value 
in uniform \code{range(angle_bg)} is used for every character.}

\item{col_lbl}{Default color of text labels.
Default: \code{col_lbl = "black"}.}

\item{col_lbl_hi}{Highlighting color of text labels.
Default: \code{col_lbl_hi = pal_ds4psy[[1]]}.}

\item{col_lbl_lo}{De-emphasizing color of text labels.
Default: \code{col_lbl_lo = pal_ds4psy[[9]]}.}

\item{col_bg}{Default color to fill background tiles.
Default: \code{col_bg = pal_ds4psy[[7]]}.}

\item{col_bg_hi}{Highlighting color to fill background tiles.
Default: \code{col_bg_hi = pal_ds4psy[[4]]}.}

\item{col_bg_lo}{De-emphasizing color to fill background tiles.
Default: \code{col_bg_lo = "white"}.}

\item{col_sample}{Boolean: Sample color vectors (within category)?
Default: \code{col_sample = FALSE}.}

\item{rseed}{Random seed (number).
Default: \code{rseed = NA} (using random seed).}

\item{cex}{Character size (numeric). 
Default: \code{cex = 3}.}

\item{fontface}{Font face of text labels (numeric). 
Default: \code{fontface = 1}, (from 1 to 4).}

\item{family}{Font family of text labels (name).
Default: \code{family = "sans"}. 
Alternative options: "sans", "serif", or "mono".}

\item{borders}{Boolean: Add borders to tiles? 
Default: \code{borders = FALSE} (i.e., no borders).}

\item{border_col}{Color of tile borders. 
Default: \code{border_col = "white"}.}

\item{border_size}{Size of tile borders. 
Default: \code{border_size = 0.5}.}
}
\value{
An invisible data frame describing the plot.
}
\description{
\code{plot_chars} parses text (from a file or user input) 
into a table and then plots its individual characters 
as a tile plot (using \strong{ggplot2}).
}
\details{
\code{plot_chars} blurs the boundary between a text 
and its graphical representation by combining options 
for matching patterns of text with visual features 
for displaying characters (e.g., their color or orientation). 

\code{plot_chars} is based on \code{\link{plot_text}}, 
but provides additional support for detecting and displaying characters 
(i.e., text labels, their orientation, and color options) 
based on matching regular expression (regex). 

Internally, \code{plot_chars} is a wrapper that calls 
(1) \code{\link{map_text_regex}} for creating a character map 
(allowing for matching patterns for some aesthetics) and 
(2) \code{\link{plot_charmap}} for plotting this character map. 

However, in contrast to \code{\link{plot_charmap}}, 
\code{plot_chars} invisibly returns a 
description of the plot (as a data frame). 

The plot generated by \code{plot_chars} is character-based: 
Individual characters are plotted at equidistant x-y-positions 
and the aesthetic settings provided for text labels and tile fill colors. 

Five regular expressions and corresponding 
color and angle arguments allow identifying, 
marking (highlighting or de-emphasizing), and rotating 
those sets of characters (i.e, their text labels or fill colors).
that match the provided patterns.
}
\examples{
# (A) From text string(s):
plot_chars(x = c("Hello world!", "Does this work?", 
                 "That's good.", "Please carry on..."))

# (B) From user input:
# plot_chars()  # (enter text in Console)

# (C) From text file:
# Create and use a text file: 
# cat("Hello world!", "This is a test file.", 
#     "Can you see this text?", 
#     "Good! Please carry on...", 
#     file = "test.txt", sep = "\n")

# plot_chars(file = "test.txt")  # default
# plot_chars(file = "test.txt", lbl_hi = "[[:upper:]]", lbl_lo = "[[:punct:]]", 
#            col_lbl_hi = "red", col_lbl_lo = "blue")
 
# plot_chars(file = "test.txt", lbl_hi = "[aeiou]", col_lbl_hi = "red", 
#            col_bg = "white", bg_hi = "see")  # mark vowels and "see" (in bg)
# plot_chars(file = "test.txt", bg_hi = "[aeiou]", col_bg_hi = "gold")  # mark (bg of) vowels

## Label options:
# plot_chars(file = "test.txt", bg_hi = "see", lbl_tiles = FALSE)
# plot_chars(file = "test.txt", cex = 5, family = "mono", fontface = 4, lbl_angle = c(-20, 20))

## Note: plot_chars() invisibly returns a description of the plot (as df):
# tb <- plot_chars(file = "test.txt", lbl_hi = "[aeiou]", lbl_rotate = TRUE)
# head(tb)

# unlink("test.txt")  # clean up (by deleting file).

\donttest{
## (B) From text file (in subdir):
# plot_chars(file = "data-raw/txt/hello.txt")  # requires txt file
# plot_chars(file = "data-raw/txt/ascii.txt", lbl_hi = "[2468]", bg_lo = "[[:digit:]]", 
#            col_lbl_hi = "red", cex = 10, fontface = 2)
           
## (C) User input:
# plot_chars()  # (enter text in Console)
}

}
\seealso{
\code{\link{plot_charmap}} for plotting character maps; 
\code{\link{plot_text}} for plotting characters and color tiles by frequency; 
\code{\link{map_text_coord}} for mapping text to a table of character coordinates; 
\code{\link{map_text_regex}} for mapping text to a character table and matching patterns; 
\code{\link{read_ascii}} for reading text inputs into a character string; 
\code{\link{pal_ds4psy}} for default color palette.

Other plot functions: 
\code{\link{plot_charmap}()},
\code{\link{plot_fn}()},
\code{\link{plot_fun}()},
\code{\link{plot_n}()},
\code{\link{plot_text}()},
\code{\link{plot_tiles}()},
\code{\link{theme_clean}()},
\code{\link{theme_ds4psy}()},
\code{\link{theme_empty}()}
}
\concept{plot functions}
