% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{words_to_text}
\alias{words_to_text}
\title{Paste or collapse words \code{x} into a text.}
\usage{
words_to_text(x, collapse = " ")
}
\arguments{
\item{x}{A string of text (required), typically a character vector.}

\item{collapse}{A character string to separate the elements of \code{x} 
in the resulting text. 
Default: \code{collapse = " "}.}
}
\value{
A text (as a collapsed character vector).
}
\description{
\code{words_to_text} pastes or collapses 
a character string \code{x} into a text.
}
\details{
Internally, \code{words_to_text} only invokes the \strong{base} R function 
\code{\link{paste}} with the \code{collapse} argument.
}
\examples{
x <- c("Hello world!", "A 1st sentence.", "A 2nd sentence.", "The end.")
words_to_text(x)
cat(words_to_text(x, collapse = "\n"))

}
\seealso{
\code{\link{text_to_words}} for splitting a text into its words; 
\code{\link{text_to_sentences}} for splitting text into a vector of sentences;  
\code{\link{text_to_chars}} for splitting text into a vector of characters;  
\code{\link{count_words}} for counting the frequency of words; 
\code{\link{strsplit}} for splitting strings.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
