% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{count_words}
\alias{count_words}
\title{Count the frequency of words in a string of text \code{x}.}
\usage{
count_words(x, case_sense = TRUE, sort_freq = TRUE)
}
\arguments{
\item{x}{A string of text (required).}

\item{case_sense}{Boolean: Distinguish lower- vs. uppercase characters? 
Default: \code{case_sense = TRUE}.}

\item{sort_freq}{Boolean: Sort output by word frequency? 
Default: \code{sort_freq = TRUE}.}
}
\value{
A named numeric vector.
}
\description{
\code{count_words} provides frequency counts of the 
words in a string of text \code{x} 
as a named numeric vector.
}
\details{
Special (or non-word) characters are removed and not counted. 

The quantification is case-sensitive and the resulting  
vector is sorted by name (alphabetically) or 
by frequency (per default).
}
\examples{
# Default: 
s3 <- c("A first sentence.", "The second sentence.", 
        "A third --- and also THE FINAL --- SENTENCE.")
count_words(s3)  # case-sensitive, sorts by frequency 

# Options: 
count_words(s3, case_sense = FALSE)  # case insensitive
count_words(s3, sort_freq = FALSE)   # sorts alphabetically

}
\seealso{
\code{\link{count_chars}} for counting the frequency of characters;   
\code{\link{count_chars_words}} for counting both characters and words; 
\code{\link{plot_chars}} for a character plotting function.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
